% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operation_setcomplement.R
\name{setcomplement}
\alias{setcomplement}
\alias{setcomplement.Set}
\alias{setcomplement.Interval}
\alias{setcomplement.FuzzySet}
\alias{setcomplement.FuzzyTuple}
\alias{setcomplement.ConditionalSet}
\alias{setcomplement.Reals}
\alias{setcomplement.Rationals}
\alias{setcomplement.Integers}
\alias{setcomplement.ComplementSet}
\alias{-.Set}
\title{Complement of Two Sets}
\usage{
setcomplement(x, y, simplify = TRUE)

\method{setcomplement}{Set}(x, y, simplify = TRUE)

\method{setcomplement}{Interval}(x, y, simplify = TRUE)

\method{setcomplement}{FuzzySet}(x, y, simplify = TRUE)

\method{setcomplement}{FuzzyTuple}(x, y, simplify = TRUE)

\method{setcomplement}{ConditionalSet}(x, y, simplify = TRUE)

\method{setcomplement}{Reals}(x, y, simplify = TRUE)

\method{setcomplement}{Rationals}(x, y, simplify = TRUE)

\method{setcomplement}{Integers}(x, y, simplify = TRUE)

\method{setcomplement}{ComplementSet}(x, y, simplify = TRUE)

\method{-}{Set}(x, y)
}
\arguments{
\item{x, y}{Set}

\item{simplify}{logical, if \code{TRUE} (default) returns the result in its simplest form, usually a \code{Set} or
\link{UnionSet}, otherwise a \code{ComplementSet}.}
}
\value{
An object inheriting from \code{Set} containing the set difference of elements in \code{x} and \code{y}.
}
\description{
Returns the set difference of two objects inheriting from class \code{Set}. If \code{y} is missing
then the complement of \code{x} from its universe is returned.
}
\details{
The difference of two sets, \eqn{X, Y}, is defined as the set of elements that exist
in set \eqn{X} and not \eqn{Y},
\deqn{X-Y = \{z : z \epsilon X \quad and \quad \neg(z \epsilon Y)\}}{X-Y = {z : z \epsilon X and !(z \epsilon Y)}}

The set difference of two \link{ConditionalSet}s is defined by combining their defining functions by a negated
'and', \verb{!&}, operator. See examples.

The complement of fuzzy and crisp sets first coerces fuzzy sets to crisp sets by finding their support.
}
\examples{
# absolute complement
setcomplement(Set$new(1,2,3, universe = Reals$new()))
setcomplement(Set$new(1,2, universe = Set$new(1,2,3,4,5)))

# complement of two sets

Set$new(-2:4) - Set$new(2:5)
setcomplement(Set$new(1,4,"a"), Set$new("a", 6))

# complement of two intervals

Interval$new(1, 10) - Interval$new(5, 15)
Interval$new(1, 10) - Interval$new(-15, 15)
Interval$new(1, 10) - Interval$new(-1, 2)

# complement of mixed set types

Set$new(1:10) - Interval$new(5, 15)
Set$new(5,7) - Tuple$new(6, 8, 7)

# FuzzySet-Set returns a FuzzySet
FuzzySet$new(1, 0.1, 2, 0.5) - Set$new(2:5)
# Set-FuzzySet returns a Set
Set$new(2:5) - FuzzySet$new(1, 0.1, 2, 0.5)

# complement of conditional sets

ConditionalSet$new(function(x, y, simplify = TRUE) x >= y) -
    ConditionalSet$new(function(x, y, simplify = TRUE) x == y)

# complement of special sets
Reals$new() - NegReals$new()
Rationals$new() - PosRationals$new()
Integers$new() - PosIntegers$new()

}
\seealso{
Other operators: 
\code{\link{powerset}()},
\code{\link{setintersect}()},
\code{\link{setpower}()},
\code{\link{setproduct}()},
\code{\link{setsymdiff}()},
\code{\link{setunion}()}
}
\concept{operators}
