% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.sf}
\alias{get_key_pos}
\alias{plot.sfc_POINT}
\alias{plot.sfc_MULTIPOINT}
\alias{plot.sfc_LINESTRING}
\alias{plot.sfc_CIRCULARSTRING}
\alias{plot.sfc_MULTILINESTRING}
\alias{plot.sfc_POLYGON}
\alias{plot.sfc_MULTIPOLYGON}
\alias{plot.sfc_GEOMETRYCOLLECTION}
\alias{plot.sfc_GEOMETRY}
\alias{plot.sfg}
\alias{plot_sf}
\alias{sf.colors}
\title{plot sf object}
\usage{
\method{plot}{sf}(
  x,
  y,
  ...,
  main,
  pal = NULL,
  nbreaks = 10,
  breaks = "pretty",
  max.plot = if (is.null(n <- options("sf_max.plot")[[1]])) 9 else n,
  key.pos = get_key_pos(x, ...),
  key.length = 0.618,
  key.width = lcm(1.8),
  reset = TRUE,
  logz = FALSE,
  extent = x,
  xlim = st_bbox(extent)[c(1, 3)],
  ylim = st_bbox(extent)[c(2, 4)]
)

get_key_pos(x, ...)

\method{plot}{sfc_POINT}(
  x,
  y,
  ...,
  pch = 1,
  cex = 1,
  col = 1,
  bg = 0,
  lwd = 1,
  lty = 1,
  type = "p",
  add = FALSE
)

\method{plot}{sfc_MULTIPOINT}(
  x,
  y,
  ...,
  pch = 1,
  cex = 1,
  col = 1,
  bg = 0,
  lwd = 1,
  lty = 1,
  type = "p",
  add = FALSE
)

\method{plot}{sfc_LINESTRING}(x, y, ..., lty = 1, lwd = 1, col = 1, pch = 1, type = "l", add = FALSE)

\method{plot}{sfc_CIRCULARSTRING}(x, y, ...)

\method{plot}{sfc_MULTILINESTRING}(x, y, ..., lty = 1, lwd = 1, col = 1, pch = 1, type = "l", add = FALSE)

\method{plot}{sfc_POLYGON}(
  x,
  y,
  ...,
  lty = 1,
  lwd = 1,
  col = NA,
  cex = 1,
  pch = NA,
  border = 1,
  add = FALSE,
  rule = "evenodd"
)

\method{plot}{sfc_MULTIPOLYGON}(
  x,
  y,
  ...,
  lty = 1,
  lwd = 1,
  col = NA,
  border = 1,
  add = FALSE,
  rule = "evenodd"
)

\method{plot}{sfc_GEOMETRYCOLLECTION}(
  x,
  y,
  ...,
  pch = 1,
  cex = 1,
  bg = 0,
  lty = 1,
  lwd = 1,
  col = 1,
  border = 1,
  add = FALSE
)

\method{plot}{sfc_GEOMETRY}(
  x,
  y,
  ...,
  pch = 1,
  cex = 1,
  bg = 0,
  lty = 1,
  lwd = 1,
  col = ifelse(st_dimension(x) == 2, NA, 1),
  border = 1,
  add = FALSE
)

\method{plot}{sfg}(x, ...)

plot_sf(
  x,
  xlim = NULL,
  ylim = NULL,
  asp = NA,
  axes = FALSE,
  bgc = par("bg"),
  ...,
  xaxs,
  yaxs,
  lab,
  setParUsrBB = FALSE,
  bgMap = NULL,
  expandBB = c(0, 0, 0, 0),
  graticule = NA_crs_,
  col_graticule = "grey",
  border,
  extent = x
)

sf.colors(n = 10, cutoff.tails = c(0.35, 0.2), alpha = 1, categorical = FALSE)
}
\arguments{
\item{x}{object of class sf}

\item{y}{ignored}

\item{...}{further specifications, see \link{plot_sf} and \link{plot} and details.}

\item{main}{title for plot (\code{NULL} to remove)}

\item{pal}{palette function, similar to \link{rainbow}, or palette values; if omitted, \code{sf.colors} is used}

\item{nbreaks}{number of colors breaks (ignored for \code{factor} or \code{character} variables)}

\item{breaks}{either a numeric vector with the actual breaks, or a name of a method accepted by the \code{style} argument of \link[classInt]{classIntervals}}

\item{max.plot}{integer; lower boundary to maximum number of attributes to plot; the default value (9) can be overriden by setting the global option \code{sf_max.plot}, e.g. \code{options(sf_max.plot=2)}}

\item{key.pos}{integer; side to plot a color key: 1 bottom, 2 left, 3 top, 4 right; set to \code{NULL} to omit key completely, 0 to only not plot the key, or -1 to select automatically. If multiple columns are plotted in a single function call by default no key is plotted and every submap is stretched individually; if a key is requested (and \code{col} is missing) all maps are colored according to a single key. Auto select depends on plot size, map aspect, and, if set, parameter \code{asp}.}

\item{key.length}{amount of space reserved for the key along its axis, length of the scale bar}

\item{key.width}{amount of space reserved for the key (incl. labels), thickness/width of the scale bar}

\item{reset}{logical; if \code{FALSE}, keep the plot in a mode that allows adding further map elements; if \code{TRUE} restore original mode after plotting \code{sf} objects with attributes; see details.}

\item{logz}{logical; if \code{TRUE}, use log10-scale for the attribute variable. In that case, \code{breaks} and \code{at} need to be given as log10-values; see examples.}

\item{extent}{object with an \code{st_bbox} method to define plot extent; defaults to \code{x}}

\item{xlim}{see \link{plot.window}}

\item{ylim}{see \link{plot.window}}

\item{pch}{plotting symbol}

\item{cex}{symbol size}

\item{col}{color for plotting features; if \code{length(col)} does not equal 1 or \code{nrow(x)}, a warning is emitted that colors will be recycled. Specifying \code{col} suppresses plotting the legend key.}

\item{bg}{symbol background color}

\item{lwd}{line width}

\item{lty}{line type}

\item{type}{plot type: 'p' for points, 'l' for lines, 'b' for both}

\item{add}{logical; add to current plot? Note that when using \code{add=TRUE}, you may have to set \code{reset=FALSE} in the first plot command.}

\item{border}{color of polygon border(s)}

\item{rule}{see \link[graphics]{polypath}; for \code{winding}, exterior ring direction should be opposite that of the holes; with \code{evenodd}, plotting is robust against misspecified ring directions}

\item{asp}{see below, and see \link{par}}

\item{axes}{logical; should axes be plotted? (default FALSE)}

\item{bgc}{background color}

\item{xaxs}{see \link{par}}

\item{yaxs}{see \link{par}}

\item{lab}{see \link{par}}

\item{setParUsrBB}{default FALSE; set the \code{par} \dQuote{usr} bounding box; see below}

\item{bgMap}{object of class \code{ggmap}, or returned by function \code{RgoogleMaps::GetMap}}

\item{expandBB}{numeric; fractional values to expand the bounding box with,
in each direction (bottom, left, top, right)}

\item{graticule}{logical, or object of class \code{crs} (e.g., \code{st_crs(4326)} for a WGS84 graticule), or object created by \link{st_graticule}; \code{TRUE} will give the WGS84 graticule
or object returned by \link{st_graticule}}

\item{col_graticule}{color to used for the graticule (if present)}

\item{n}{integer; number of colors}

\item{cutoff.tails}{numeric, in [0,0.5] start and end values}

\item{alpha}{numeric, in [0,1], transparency}

\item{categorical}{logical; do we want colors for a categorical variable? (see details)}
}
\description{
plot one or more attributes of an sf object on a map
Plot sf object
}
\details{
\code{plot.sf} maximally plots \code{max.plot} maps with colors following from attribute columns,
one map per attribute. It uses \code{sf.colors} for default colors. For more control over placement of individual maps,
set parameter \code{mfrow} with \link{par} prior to plotting, and plot single maps one by one; note that this only works
in combination with setting parameters \code{key.pos=NULL} (no legend) and \code{reset=FALSE}.

\code{plot.sfc} plots the geometry, additional parameters can be passed on
to control color, lines or symbols.

When setting \code{reset} to \code{FALSE}, the original device parameters are lost, and the device must be reset using \code{dev.off()} in order to reset it.

parameter \code{at} can be set to specify where labels are placed along the key; see examples.

\code{plot_sf} sets up the plotting area, axes, graticule, or webmap background; it
is called by all \code{plot} methods before anything is drawn.

The argument \code{setParUsrBB} may be used to pass the logical value \code{TRUE} to functions within \code{plot.Spatial}. When set to \code{TRUE}, par(\dQuote{usr}) will be overwritten with \code{c(xlim, ylim)}, which defaults to the bounding box of the spatial object. This is only needed in the particular context of graphic output to a specified device with given width and height, to be matched to the spatial object, when using par(\dQuote{xaxs}) and par(\dQuote{yaxs}) in addition to \code{par(mar=c(0,0,0,0))}.

The default aspect for map plots is 1; if however data are not
projected (coordinates are long/lat), the aspect is by default set to
1/cos(My * pi/180) with My the y coordinate of the middle of the map
(the mean of \code{ylim}, which defaults to the y range of bounding box). This
implies an \href{https://en.wikipedia.org/wiki/Equirectangular_projection}{Equirectangular projection}.

non-categorical colors from \code{sf.colors} were taken from \link[sp]{bpy.colors}, with modified \code{cutoff.tails} defaults
If categorical is \code{TRUE}, default colors are from \url{https://colorbrewer2.org/} (if n < 9, Set2, else Set3).
}
\examples{
nc = st_read(system.file("gpkg/nc.gpkg", package="sf"), quiet = TRUE)
# plot single attribute, auto-legend:
plot(nc["SID74"])
# plot multiple:
plot(nc[c("SID74", "SID79")]) # better use ggplot2::geom_sf to facet and get a single legend!
# adding to a plot of an sf object only works when using reset=FALSE in the first plot:
plot(nc["SID74"], reset = FALSE)
plot(st_centroid(st_geometry(nc)), add = TRUE)
# log10 z-scale:
plot(nc["SID74"], logz = TRUE, breaks = c(0,.5,1,1.5,2), at = c(0,.5,1,1.5,2))
# and we need to reset the plotting device after that, e.g. by
layout(1)
# when plotting only geometries, the reset=FALSE is not needed:
plot(st_geometry(nc))
plot(st_geometry(nc)[1], col = 'red', add = TRUE)
# add a custom legend to an arbitray plot:
layout(matrix(1:2, ncol = 2), widths = c(1, lcm(2)))
plot(1)
.image_scale(1:10, col = sf.colors(9), key.length = lcm(8), key.pos = 4, at = 1:10)
sf.colors(10)
}
