% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgnht.R
\name{sgnht}
\alias{sgnht}
\title{Stochastic Gradient Nose Hoover Thermostat}
\usage{
sgnht(logLik, dataset, params, stepsize, logPrior = NULL,
  minibatchSize = 0.01, a = 0.01, nIters = 10^4L, verbose = TRUE,
  seed = NULL)
}
\arguments{
\item{logLik}{function which takes parameters and dataset 
(list of TensorFlow variables and placeholders respectively) as input. 
It should return a TensorFlow expression which defines the log likelihood of the model.}

\item{dataset}{list of numeric R arrays which defines the datasets for the problem.
The names in the list should correspond to those referred to in the logLik and logPrior functions}

\item{params}{list of numeric R arrays which define the starting point of each parameter.
The names in the list should correspond to those referred to in the logLik and logPrior functions}

\item{stepsize}{list of numeric values corresponding to the SGLD stepsizes for each parameter
The names in the list should correspond to those in params.
Alternatively specify a single numeric value to use that stepsize for all parameters.}

\item{logPrior}{optional. Default uninformative improper prior.
Function which takes parameters (list of TensorFlow variables) as input.
The function should return a TensorFlow tensor which defines the log prior of the model.}

\item{minibatchSize}{optional. Default 0.01.
Numeric or integer value that specifies amount of dataset to use at each iteration 
either as proportion of dataset size (if between 0 and 1) or actual magnitude (if an integer).}

\item{a}{optional. Default 0.01. List of numeric values corresponding to SGNHT diffusion factors
(see Algorithm 2 of the original paper). One value should be given 
for each parameter in params, the names should correspond to those in params.
Alternatively specify a single float to specify that value for all parameters.}

\item{nIters}{optional. Default 10^4L. Integer specifying number of iterations to perform.}

\item{verbose}{optional. Default TRUE. Boolean specifying whether to print algorithm progress}

\item{seed}{optional. Default NULL. Numeric seed for random number generation. The default
does not declare a seed for the TensorFlow session.}
}
\value{
Returns list of arrays for each parameter containing the MCMC chain.
 Dimension of the form (nIters,paramDim1,paramDim2,...)
}
\description{
Simulates from the posterior defined by the functions logLik and logPrior using
 stochastic gradient Nose Hoover Thermostat.
 The thermostat step needs a dot product to be calculated between two vectors.
 So when the algorithm uses parameters that are higher order than vectors 
 (e.g. matrices and tensors), the thermostat step uses a tensor contraction.
 Tensor contraction is otherwise known as the inner product between two tensors.
}
\examples{
\dontrun{
# Simulate from a Normal Distribution with uninformative, improper prior
dataset = list("x" = rnorm(1000))
params = list("theta" = 0)
logLik = function(params, dataset) { 
    distn = tf$distributions$Normal(params$theta, 1)
    return(tf$reduce_sum(distn$log_prob(dataset$x)))
}
stepsize = list("theta" = 5e-6)
output = sgnht(logLik, dataset, params, stepsize)
# For more examples see vignettes
}
}
\references{
\itemize{\item \href{http://people.ee.duke.edu/~lcarin/sgnht-4.pdf}{
 Ding, N., Fang, Y., Babbush, R., Chen, C., Skeel, R. D., and Neven, H. (2014). 
 Bayesian sampling using stochastic gradient thermostats. NIPS (pp. 3203-3211).}}
}
