% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{sgmcmcStep}
\alias{sgmcmcStep}
\title{Single step of sgmcmc}
\usage{
sgmcmcStep(sgmcmc, sess)
}
\arguments{
\item{sgmcmc}{a stochastic gradient MCMC object returned by *Setup such as 
\code{\link{sgldSetup}}, \code{\link{sgldcvSetup}} etc.}

\item{sess}{a TensorFlow session created using \code{\link{initSess}}}
}
\description{
Update parameters by performing a single sgmcmc step with dynamics as defined in the sgmcmc 
 object. This can be used to perform sgmcmc steps inside a loop as in standard
 TensorFlow optimization procedures.
 This is useful when high dimensional chains cannot fit into memory.
}
\examples{
\dontrun{
# Simulate from a Normal Distribution, unknown location and known scale with uninformative prior
# Run sgmcmc step by step and calculate estimate of location on the fly to reduce storage
dataset = list("x" = rnorm(1000))
params = list("theta" = 0)
logLik = function(params, dataset) {
    distn = tf$distributions$Normal(params$theta, 1)
    return(tf$reduce_sum(distn$log_prob(dataset$x)))
}
stepsize = list("theta" = 1e-4)
sgld = sgldSetup(logLik, dataset, params, stepsize)
nIters = 10^4L
# Initialize location estimate
locEstimate = 0
# Initialise TensorFlow session
sess = initSess(sgld)
for ( i in 1:nIters ) {
    sgmcmcStep(sgld, sess)
    locEstimate = locEstimate + 1 / nIters * getParams(sgld, sess)$theta
}
# For more examples see vignettes
}
}
