% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ray.R
\name{ray}
\alias{ray}
\title{Line between two points}
\usage{
ray(from, to)
}
\arguments{
\item{from}{A \code{SpatialPoints*} object specifying origin.}

\item{to}{A \code{SpatialPoints*} object specifying destination.}
}
\value{
A \code{SpatialLines} object.
}
\description{
The function connects two points into a line segment.
}
\examples{
ctr = rgeos::gCentroid(build)
angles = seq(0, 359, 20)
sun = mapply(
  shadow:::.sunLocation,
  sun_az = angles,
  MoreArgs = list(
    location = ctr,
    sun_elev = 10)
)
rays = mapply(ray, MoreArgs = list(from = ctr), to = sun)
rays$makeUniqueIDs = TRUE
rays = do.call(rbind, rays)
plot(rays)
sun = do.call(rbind, sun)
text(sun, as.character(angles))

}
