% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowlength.R
\name{flowlength}
\alias{flowlength}
\title{Calculate flow length}
\usage{
flowlength(elev, veg, res = 1)
}
\arguments{
\item{elev}{A numeric \code{matrix} representing a Digital Elevation Model (DEM)}

\item{veg}{A logical \code{matrix} representing vegetation presence. \code{TRUE} values represent vegetated cells where flow is absorbed (i.e. sinks), \code{FALSE} values represent cells where flow is unobstructed}

\item{res}{\code{numeric} vector of length 1, specifying DEM resolution. Default is 1, i.e. pixel size is 1*1}
}
\value{
A numeric \code{matrix} where each cell value is flow length, in \code{res} units
}
\description{
Calculates flow length for each pixel in a Digital Elevation Model.
}
\examples{
# Example from Fig. 2 in Mayor et al. 2008

elev = rbind(
  c(8, 8, 8, 8, 9, 8, 9),
  c(7, 7, 7, 7, 9, 7, 7),
  c(6, 6, 6, 6, 6, 5, 7),
  c(4, 5, 5, 3, 5, 4, 7),
  c(4, 5, 4, 5, 4, 6, 5),
  c(3, 3, 3, 3, 2, 3, 3),
  c(2, 2, 2, 3, 4, 1, 3)
)
veg = rbind(
  c(TRUE,  TRUE,  TRUE,  TRUE,  FALSE, FALSE, TRUE),
  c(TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  FALSE, FALSE),
  c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE),
  c(FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, TRUE),
  c(TRUE,  TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE),
  c(TRUE,  TRUE,  TRUE,  FALSE, FALSE, FALSE, FALSE),
  c(FALSE, TRUE,  TRUE,  FALSE, FALSE, TRUE,  TRUE)
)

# Calculate flow length
f = flowlength(elev, veg)

# Plot
library(raster)
r = raster(f)
pnt = rasterToPoints(r)
plot(r, main = "Flow length")
text(pnt[, 1:2], as.character(round(pnt[, 3], 1)))

}
\references{
The algorithm is described in:

Mayor, A. G., Bautista, S., Small, E. E., Dixon, M., & Bellot, J. (2008). Measurement of the connectivity of runoff source areas as determined by vegetation pattern and topography: A tool for assessing potential water and soil losses in drylands. Water Resources Research, 44(10).
}
