% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{Heatmap}
\alias{Heatmap}
\title{Heatmap visualisation}
\usage{
Heatmap(
  mat,
  col = c("ivory", "navajowhite", "tomato", "darkred"),
  resolution = 10000,
  bty = "o",
  axes = TRUE,
  cex.axis = 1,
  xlas = 2,
  ylas = 2,
  text = FALSE,
  cex = 1,
  digits = 2,
  legend = TRUE,
  legend_length = NULL,
  legend_range = NULL
)
}
\arguments{
\item{mat}{data matrix.}

\item{col}{vector of colours.}

\item{resolution}{number of different colours to use.}

\item{bty}{character string indicating if the box around the plot should be
drawn. Possible values include: \code{"o"} (default, the box is drawn), or
\code{"n"} (no box).}

\item{axes}{logical indicating if the row and column names of \code{mat}
should be displayed.}

\item{cex.axis}{font size for axes.}

\item{xlas}{orientation of labels on the x-axis, as \code{las} in
\code{\link[graphics]{par}}.}

\item{ylas}{orientation of labels on the y-axis, as \code{las} in
\code{\link[graphics]{par}}.}

\item{text}{logical indicating if numbers should be displayed.}

\item{cex}{font size for numbers. Only used if \code{text=TRUE}.}

\item{digits}{number of digits to show. Only used if \code{text=TRUE}.}

\item{legend}{logical indicating if the colour bar should be included.}

\item{legend_length}{length of the colour bar.}

\item{legend_range}{range of the colour bar.}
}
\value{
A heatmap.
}
\description{
Produces a heatmap for visualisation of matrix entries.
}
\examples{
oldpar <- par(no.readonly = TRUE)
par(mar = c(3, 3, 1, 5))

# Data simulation
set.seed(1)
mat <- matrix(rnorm(200), ncol = 20)
rownames(mat) <- paste0("r", 1:nrow(mat))
colnames(mat) <- paste0("c", 1:ncol(mat))

# Generating heatmaps
Heatmap(mat = mat)
Heatmap(
  mat = mat,
  col = c("lightgrey", "blue", "black"),
  legend = FALSE
)

par(oldpar)
}
\seealso{
\code{\link{CalibrationPlot}}
}
