% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{plotMutability}
\alias{plotMutability}
\title{Plot mutability probabilities}
\usage{
plotMutability(model, nucleotides = c("A", "C", "G", "T"),
  style = c("hedgehog", "bar"), size = 1, silent = FALSE, ...)
}
\arguments{
\item{model}{\link{TargetingModel} object or vector containing normalized 
mutability rates.}

\item{nucleotides}{vector of center nucleotide characters to plot.}

\item{style}{type of plot to draw. One of:
\itemize{
  \item \code{"hedgehog"}:  circular plot showing higher mutability
                            scores further from the circle. The 5-mer
                            is denoted by the values of the inner 
                            circle. The 5-mer is read from the most interior 
                            position of the 5-mer (5') to most exterior position 
                            (3'), with the center nucleotide in the center ring.
                            Note, the order in which the 5-mers are plotted is
                            different for nucleotides \code{c("A", "C")} and 
                            \code{c("G", "T")}.
  \item \code{"bar"}:       bar plot of mutability similar to the 
                            \code{hedgehog} style with the most 5' positions
                            of each 5-mer at the base of the plot.
}}

\item{size}{numeric scaling factor for lines and text in the plot.}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
objects; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A named list of ggplot objects defining the plots, with names defined by the 
          center nucleotide for the plot object.
}
\description{
\code{plotMutability} plots the mutability rates of a \code{TargetingModel}.
}
\examples{
# Plot one nucleotide in circular style
plotMutability(HS5FModel, "C")

# Plot two nucleotides in barchart style
plotMutability(HS5FModel, c("G", "T"), style="bar")

}
\seealso{
Takes as input a \link{TargetingModel} object. 
          See \link{createTargetingModel} for model building.
}

