% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_multivari_plot.R
\name{draw_multivari_plot}
\alias{draw_multivari_plot}
\title{Draw Multivari Plot}
\usage{
draw_multivari_plot(
  data,
  response,
  factor_1,
  factor_2,
  factor_3,
  plot_means = FALSE,
  x_axis_text_size = 11,
  panel_text_size = 14,
  point_size = 2.5,
  line_size = 0.7,
  alpha = 0.6
)
}
\arguments{
\item{data}{input dataset to be plotted (required)}

\item{response}{response variable, Y (required)}

\item{factor_1}{lowest level factor (required)}

\item{factor_2}{mid-level factor (required)}

\item{factor_3}{top level factor (optional)}

\item{plot_means}{logical. if FALSE, default, means for mid-level factor are not plotted (optional)}

\item{x_axis_text_size}{set x axis text size. options are "normal" (default), "small", "xs" and "none" (optional)}

\item{panel_text_size}{set panel text size. By default, it is set to 14 (optional)}

\item{point_size}{Set point size. By default, it is set to 2.5  (optional)}

\item{line_size}{Set line size. By default, it is set to 0.7  (optional)}

\item{alpha}{Set transparency. By default, it is set to 0.6  (optional)}
}
\value{
A 'ggplot' object
}
\description{
Draws a multivari small multiples plot
}
\examples{
library(dplyr)
library(ggh4x)

polar_small_multiples_data \%>\%
  filter(ID_Measurement_Angle \%in\% c(0, 45, 90, 135)) \%>\%
  normalize_observations(response = ID,
                         grouping_var = Tip_Bottom,
                         ref_values = c(0.2075, 0.2225)) \%>\%
  draw_multivari_plot(response    = ID_normalized,
                     factor_1    = ID_Measurement_Angle,
                     factor_2    = Mold_Cavity_Number,
                     factor_3    = Tip_Bottom,
                     x_axis_text = 6) +
  draw_horizontal_reference_line(reference_line = 0)

}
