% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card.R
\name{card}
\alias{card}
\alias{card2}
\alias{card2_open}
\alias{card2_close}
\alias{card2_toggle}
\alias{card_operate}
\title{Card-like 'HTML' element}
\usage{
card(
  title,
  ...,
  footer = NULL,
  tools = NULL,
  inputId = NULL,
  class = "",
  class_header = "",
  class_body = "",
  class_foot = "",
  style_header = NULL,
  style_body = NULL,
  start_collapsed = FALSE,
  resizable = FALSE,
  root_path = template_root()
)

card2(
  title,
  body_main,
  body_side = NULL,
  footer = NULL,
  tools = NULL,
  inputId = NULL,
  class = "",
  class_header = "",
  class_body = "min-height-400",
  class_foot = "",
  style_header = NULL,
  style_body = NULL,
  start_collapsed = FALSE,
  root_path = template_root()
)

card2_open(inputId, session = shiny::getDefaultReactiveDomain())

card2_close(inputId, session = shiny::getDefaultReactiveDomain())

card2_toggle(inputId, session = shiny::getDefaultReactiveDomain())

card_operate(inputId, method, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{title}{the title of the card}

\item{...}{the body content of the card}

\item{footer}{the footer of the card; will be hidden if
\code{footer=NULL}}

\item{tools}{a list of tools or badges to be displayed at
top-right corner, generated by \code{\link{as_badge}} or
\code{\link{card_tool}}}

\item{inputId}{the id of the card}

\item{class}{the 'HTML' class of the entire card}

\item{class_header}{the the 'HTML' class of the card header}

\item{class_body}{the the 'HTML' class of the card body}

\item{class_foot}{the the 'HTML' class of the card footer}

\item{style_header}{'CSS' style of the header}

\item{style_body}{'CSS' style of the body}

\item{start_collapsed}{whether the card starts as collapsed}

\item{resizable}{whether the card body can be resized vertically;
notice that if true, then the default padding for body will be zero}

\item{root_path}{see \code{\link{template_root}}}

\item{body_main, body_side}{used by \code{card2}, the body
content of the front and back sides of the card}

\item{session}{shiny session domain}

\item{method}{action to expand, minimize, or remove the cards;
choices are \code{"collapse"}, \code{"expand"}, \code{"remove"},
\code{"toggle"}, \code{"maximize"}, \code{"minimize"},
and \code{"toggleMaximize"}}
}
\value{
'HTML' tags
}
\description{
Card-like 'HTML' element
}
\examples{
library(shiny)
library(shidashi)

# Used for example only
ns <- I
session <- MockShinySession$new()

# -------------- Basic usage -------------
card(
  title = "Badges", div(
    class = "padding-20",
    p(
      "Add badges to the top-right corder. ",
      "Use \"|\" to indicate the badge classes; ",
      "for example: \"badge-info\", \"badge-warning\"..."
    ),
    hr(), p(
      "Use `resizable = TRUE` to make card resizable."
    )
  ),
  tools = list(
    as_badge("New|badge-info"),
    as_badge("3|badge-warning")
  ),
  class_body = "height-300",
  resizable = TRUE
)

# ---------------- With tools -----------------
card(
  title = "Default Tools",
  plotOutput(
    ns("card_defaulttool_plot"),
    height = "100\%"
  ),
  tools = list(
    card_tool(
      widget = "link",
      href = "https://github.com/dipterix"
    ),
    card_tool(widget = "collapse"),
    card_tool(widget = "maximize")
  ),
  class_body = "height-300",
  resizable = TRUE
)

# -------------- Card2 example --------------
card2(
  title = "Card2 Example", body_main =
    plotOutput(
    outputId = ns("card2_plot"),
    height = "100\%"
  ),
  body_side = fluidRow(
    column(
      6L, textInput(
        ns("card2_plot_title"),
        "Plot title"
      )
    ),
    column(
      6L, sliderInput(
        ns("card2_plot_npts"),
        "# of points", min = 1, max = 100,
        value = 10, step = 1, round = TRUE
      )
    )
  ),
  tools = list(
    card_tool(widget = "link",
              href = "https://github.com/dipterix"),
    card_tool(widget = "collapse"),
    card_tool(widget = "maximize")
  ),
  class_body = "height-300"
)

}
