% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accordion.R
\name{accordion}
\alias{accordion}
\title{Generates an 'accordion' tab-set}
\usage{
accordion(
  ...,
  id = rand_string(),
  class = NULL,
  style_header = NULL,
  style_body = NULL,
  env = parent.frame(),
  extras = list(),
  root_path = template_root()
)
}
\arguments{
\item{...}{'accordion' items, generated by \code{\link{accordion_item}}}

\item{id}{the element id, must be unique}

\item{class}{the additional 'HTML' class}

\item{style_header}{additional 'CSS' styles for header}

\item{style_body}{additional 'CSS' styles for content body}

\item{env}{environment to evaluate \code{...}}

\item{extras}{key-value pairs that overrides the parameters in
\code{\link{accordion_item}}}

\item{root_path}{see \code{\link{template_root}}}
}
\value{
\code{'shiny.tag.list'} 'HTML' tags
}
\description{
Generates an 'accordion' tab-set that only one tab is
expanded at a time. This feature is experimental and has bugs in
some situations. Please use it at your own risk.
}
\examples{

library(shiny)
library(shidashi)

accordion(
  id = "input-set",
  accordion_item(
    title = "Input Group A",
    textInput("input_1", "Input 1"),
    collapsed = FALSE,
    footer = "Anim pariatur cliche reprehenderit dolor brunch.",
    tools = list(
      as_badge("New|badge-danger")
      # card_tool(widget = "collapse")
    )
  ),
  accordion_item(
    title = "Input Group B",
    textInput("input_2", "Input 2"),
    footer = actionButton("btn1", "OK"),
    collapsed = FALSE,
    tools = list(
      card_tool(widget = "link",
                icon = shiny::icon("question-circle"),
                href = "#")
    )
  )
)

}
\seealso{
\code{\link{accordion_item}}
}
