% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Slider}
\alias{f7Slider}
\title{Create a f7 slider}
\usage{
f7Slider(
  inputId,
  label,
  min,
  max,
  value,
  step = NULL,
  scale = FALSE,
  vertical = FALSE
)
}
\arguments{
\item{inputId}{Slider input id.}

\item{label}{Slider label.}

\item{min}{Slider minimum range.}

\item{max}{Slider maximum range.}

\item{value}{Slider value or a vector containing 2 values (for a range).}

\item{step}{Slider increase step size.}

\item{scale}{Slider scale.}

\item{vertical}{Whether to apply a vertical display. FALSE by default. Does not work yet.}
}
\description{
Create a f7 slider
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Slider"),
     f7Card(
      f7Slider(
       inputId = "obs",
       label = "Number of observations",
       max = 1000,
       min = 0,
       value = 100,
       scale = TRUE
      ),
      verbatimTextOutput("test")
     ),
     plotOutput("distPlot")
    )
   ),
   server = function(input, output) {
    output$test <- renderPrint({input$obs})
    output$distPlot <- renderPlot({
     hist(rnorm(input$obs))
    })
   }
 )
}

# Create a range
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
    title = "My app",
    init = f7Init(theme = "auto"),
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Slider"),
     f7Card(
      f7Slider(
       inputId = "obs",
       label = "Range values",
       max = 500,
       min = 0,
       value = c(50, 100),
       scale = TRUE
      ),
      verbatimTextOutput("test")
     )
    )
   ),
   server = function(input, output) {
    output$test <- renderPrint({input$obs})
   }
 )
}

}
