% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-tabs.R
\name{f7InsertTab}
\alias{f7InsertTab}
\title{Insert a \link{f7Tab} in a \link{f7Tabs}}
\usage{
f7InsertTab(
  inputId,
  tab,
  target,
  position = c("before", "after"),
  select = FALSE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{\link{f7Tabs} id.}

\item{tab}{\link{f7Tab} to insert.}

\item{target}{\link{f7Tab} after of before which the new tab will be inserted.}

\item{position}{Insert before or after: \code{c("before", "after")}.}

\item{select}{Whether to select the newly inserted tab. FALSE by default.}

\item{session}{Shiny session object.}
}
\description{
Insert a \link{f7Tab} in a \link{f7Tabs}
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shiny::shinyApp(
   ui = f7Page(
     title = "Insert a tab Before the target",
     f7TabLayout(
       panels = tagList(
         f7Panel(title = "Left Panel", side = "left", theme = "light", "Blabla", effect = "cover"),
         f7Panel(title = "Right Panel", side = "right", theme = "dark", "Blabla", effect = "cover")
       ),
       navbar = f7Navbar(
         title = "Tabs",
         hairline = FALSE,
         shadow = TRUE,
         left_panel = TRUE,
         right_panel = TRUE
       ),
       f7Tabs(
         animated = TRUE,
         id = "tabs",
         f7Tab(
           tabName = "Tab 1",
           icon = f7Icon("email"),
           active = TRUE,
           "Tab 1",
           f7Button(inputId = "go", label = "Go")
         ),
         f7Tab(
           tabName = "Tab 2",
           icon = f7Icon("today"),
           active = FALSE,
           "Tab 2"
         )
       )
     )
   ),
   server = function(input, output, session) {
     observeEvent(input$go, {
       f7InsertTab(
         inputId = "tabs",
         position = "before",
         target = "Tab 2",
         tab = f7Tab (tabName = paste0("tab_", input$go), "Test"),
         select = TRUE
       )
     })
   }
 )
}

}
