% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Picker}
\alias{f7Picker}
\alias{updateF7Picker}
\title{Framework7 picker input}
\usage{
f7Picker(
  inputId,
  label,
  placeholder = NULL,
  value = choices[1],
  choices,
  rotateEffect = TRUE,
  openIn = "auto",
  scrollToInput = FALSE,
  closeByOutsideClick = TRUE,
  toolbar = TRUE,
  toolbarCloseText = "Done",
  sheetSwipeToClose = FALSE
)

updateF7Picker(
  inputId,
  value = NULL,
  choices = NULL,
  rotateEffect = NULL,
  openIn = NULL,
  scrollToInput = NULL,
  closeByOutsideClick = NULL,
  toolbar = NULL,
  toolbarCloseText = NULL,
  sheetSwipeToClose = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{Picker label.}

\item{placeholder}{Text to write in the container.}

\item{value}{Picker initial value, if any.}

\item{choices}{New picker choices.}

\item{rotateEffect}{Enables 3D rotate effect. Default to TRUE.}

\item{openIn}{Can be auto, popover (to open picker in popover), sheet (to open in sheet modal).
In case of auto will open in sheet modal on small screens and in popover on large screens. Default
to auto.}

\item{scrollToInput}{Scroll viewport (page-content) to input when picker opened. Default
to FALSE.}

\item{closeByOutsideClick}{If enabled, picker will be closed by clicking outside of picker or related input element.
Default to TRUE.}

\item{toolbar}{Enables picker toolbar. Default to TRUE.}

\item{toolbarCloseText}{Text for Done/Close toolbar button.}

\item{sheetSwipeToClose}{Enables ability to close Picker sheet with swipe. Default to FALSE.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
\code{f7Picker} generates a picker input.

\code{updateF7Picker} changes the value of a picker input on the client.
}
\examples{
# Picker input
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Picker"),
     f7Picker(
      inputId = "mypicker",
      placeholder = "Some text here!",
      label = "Picker Input",
      choices = c('a', 'b', 'c')
     ),
     textOutput("pickerval")
    )
   ),
   server = function(input, output) {
    output$pickerval <- renderText(input$mypicker)
   }
 )
}

# Update picker input
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(title = "Update picker"),
      f7Card(
        f7Button(inputId = "update", label = "Update picker"),
        f7Picker(
          inputId = "mypicker",
          placeholder = "Some text here!",
          label = "Picker Input",
          choices = c('a', 'b', 'c')
        ),
        verbatimTextOutput("pickerval"),
        br(),
        f7Button(inputId = "removeToolbar", label = "Remove picker toolbar", color = "red")
      )
    )
  ),
  server = function(input, output, session) {

    output$pickerval <- renderText(input$mypicker)

    observeEvent(input$update, {
      updateF7Picker(
        inputId = "mypicker",
        value = "b",
        choices = letters,
        openIn = "sheet",
        toolbarCloseText = "Prout",
        sheetSwipeToClose = TRUE
      )
    })

    observeEvent(input$removeToolbar, {
      updateF7Picker(
        inputId = "mypicker",
        value = "b",
        choices = letters,
        openIn = "sheet",
        toolbar = FALSE
      )
    })

  }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
