% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renderCurves.R
\name{renderMeltCurves}
\alias{renderMeltCurves}
\title{Renders a melting curves viewer}
\usage{
renderMeltCurves(inputId, label = NULL, meltCurves, colorBy = NULL,
  linetypeBy = NULL, showTm = FALSE, showLegend = FALSE, plotlyCode = NULL,
  cssFile = NULL, cssText = NULL, interactive = TRUE)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to modify plot.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{meltCurves}{Melting curves data with \code{RDML$GetFData(dp.type =
"mdp", long.table = TRUE)} format.}

\item{colorBy}{Column name that contains color levels data.}

\item{linetypeBy}{Column name that contains linetype levels data.}

\item{showTm}{Shows Tm with dots (\code{tm} column have to be provided!)}

\item{showLegend}{Show plot legend.}

\item{plotlyCode}{Your quoted custom plotly code.}

\item{cssFile}{Path to the css styles file.}

\item{cssText}{CSS styles as text.}

\item{interactive}{Should be this \code{pcrPlate} interactive or not.}
}
\description{
Renders a reactive melting plot that is suitable for assigning to an \code{UI
output} slot.
}
\examples{
library(RDML)
rdml <- RDML$new(system.file("/extdata/test.rdml", package = "shinyMolBio"))
curves <- renderMeltCurves("curves1", meltCurves = rdml$GetFData(dp.type = "mdp",
 long.table = TRUE))
curves[[2]][[3]][[2]]
}
\seealso{
\code{\link{updateCurves}}

Other render elements: \code{\link{renderAmpCurves}}
}
\author{
Konstantin A. Blagodatskikh <k.blag@yandex.ru>
}
\concept{render elements}
\keyword{Input}
\keyword{PCR}
\keyword{RDML}
\keyword{Shiny}
