% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-pretty.R
\name{prettyCheckboxGroup}
\alias{prettyCheckboxGroup}
\title{Pretty Checkbox Group Input Control}
\usage{
prettyCheckboxGroup(inputId, label, choices = NULL, selected = NULL,
  status = "default", shape = c("square", "curve", "round"),
  outline = FALSE, fill = FALSE, thick = FALSE, animation = NULL,
  icon = NULL, plain = FALSE, bigger = FALSE, inline = FALSE,
  width = NULL, choiceNames = NULL, choiceValues = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control.}

\item{choices}{List of values to show checkboxes for. If elements of the list
are named then that name rather than the value is displayed to the user. If
this argument is provided, then \code{choiceNames} and \code{choiceValues} must not be provided,
and vice-versa. The values should be strings; other types (such as logicals and
numbers) will be coerced to strings.}

\item{selected}{The values that should be initially selected, if any.}

\item{status}{Add a class to the checkbox,
you can use Bootstrap status like 'info', 'primary', 'danger', 'warning' or 'success'.}

\item{shape}{Shape of the checkbox between \code{square}, \code{curve} and \code{round}.}

\item{outline}{Color also the border of the checkbox (\code{TRUE} or \code{FALSE}).}

\item{fill}{Fill the checkbox with color (\code{TRUE} or \code{FALSE}).}

\item{thick}{Make the content inside checkbox smaller (\code{TRUE} or \code{FALSE}).}

\item{animation}{Add an animation when checkbox is checked, a value between
\code{smooth}, \code{jelly}, \code{tada}, \code{rotate}, \code{pulse}.}

\item{icon}{Optional, display an icon on the checkbox, must be an icon created with \code{icon}.}

\item{plain}{Remove the border when checkbox is checked (\code{TRUE} or \code{FALSE}).}

\item{bigger}{Scale the checkboxes a bit bigger (\code{TRUE} or \code{FALSE}).}

\item{inline}{If \code{TRUE}, render the choices inline (i.e. horizontally).}

\item{width}{The width of the input, e.g. \code{400px}, or \code{100\%}.}

\item{choiceNames}{List of names to display to the user.}

\item{choiceValues}{List of values corresponding to \code{choiceNames}}
}
\value{
A character vector or \code{NULL} server-side.
}
\description{
Create a group of pretty checkboxes that can be
used to toggle multiple choices independently. The
server will receive the input as a character vector
of the selected values.
}
\examples{
\dontrun{

if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h1("Pretty checkbox group"),
  br(),

  fluidRow(
    column(
      width = 4,
      prettyCheckboxGroup(inputId = "checkgroup1",
                          label = "Click me!",
                          choices = c("Click me !", "Me !", "Or me !")),
      verbatimTextOutput(outputId = "res1"),
      br(),
      prettyCheckboxGroup(inputId = "checkgroup4",  label = "Click me!",
                          choices = c("Click me !", "Me !", "Or me !"),
                          outline = TRUE,
                          plain = TRUE, icon = icon("thumbs-up")),
      verbatimTextOutput(outputId = "res4")
    ),
    column(
      width = 4,
      prettyCheckboxGroup(inputId = "checkgroup2",
                          label = "Click me!", thick = TRUE,
                          choices = c("Click me !", "Me !", "Or me !"),
                          animation = "pulse", status = "info"),
      verbatimTextOutput(outputId = "res2"),
      br(),
      prettyCheckboxGroup(inputId = "checkgroup5",
                          label = "Click me!", icon = icon("check"),
                          choices = c("Click me !", "Me !", "Or me !"),
                          animation = "tada", status = "default"),
      verbatimTextOutput(outputId = "res5")
    ),
    column(
      width = 4,
      prettyCheckboxGroup(inputId = "checkgroup3",  label = "Click me!",
                          choices = c("Click me !", "Me !", "Or me !"),
                          shape = "round", status = "danger",
                          fill = TRUE, inline = TRUE),
      verbatimTextOutput(outputId = "res3")
    )
  )

)

server <- function(input, output, session) {

  output$res1 <- renderPrint(input$checkgroup1)
  output$res2 <- renderPrint(input$checkgroup2)
  output$res3 <- renderPrint(input$checkgroup3)
  output$res4 <- renderPrint(input$checkgroup4)
  output$res5 <- renderPrint(input$checkgroup5)

}

shinyApp(ui, server)

}

}
}
\seealso{
\code{\link{updatePrettyCheckboxGroup}} for updating values server-side.
}
