% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-icon.R
\name{updateNumericInputIcon}
\alias{updateNumericInputIcon}
\title{Change the value of a numeric input icon on the client}
\usage{
updateNumericInputIcon(
  session = getDefaultReactiveDomain(),
  inputId,
  label = NULL,
  value = NULL,
  min = NULL,
  max = NULL,
  step = NULL,
  icon = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}. Default is \code{getDefaultReactiveDomain()}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{Initial value.}

\item{min}{Minimum allowed value}

\item{max}{Maximum allowed value}

\item{step}{Interval to use when stepping between min and max}

\item{icon}{Icon to update, note that you can update icon only
if initialized in \code{\link[=numericInputIcon]{numericInputIcon()}}.}
}
\value{
No value.
}
\description{
Change the value of a numeric input icon on the client
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  numericInputIcon(
    inputId = "id",
    label = "With an icon",
    value = 10,
    icon = icon("percent")
  ),
  actionButton("updateValue", "Update value"),
  actionButton("updateIcon", "Update icon"),
  verbatimTextOutput("value")
)

server <- function(input, output, session) {

  output$value <- renderPrint(input$id)

  observeEvent(input$updateValue, {
    updateNumericInputIcon(
      session = session,
      inputId = "id",
      value = sample.int(100, 1)
    )
  })

  observeEvent(input$updateIcon, {
    i <- sample(c("home", "gears", "dollar-sign", "globe", "sliders-h"), 1)
    updateNumericInputIcon(
      session = session,
      inputId = "id",
      icon = icon(i)
    )
  })

}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
\code{\link[=numericInputIcon]{numericInputIcon()}}
}
