% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinners-epic.R
\name{spin_epic}
\alias{spin_epic}
\title{Epic spinners}
\usage{
spin_epic(spin = c("flower", "pixel", "hollow-dots",
  "intersecting-circles", "orbit", "radar", "scaling-squares",
  "half-circle", "trinity-rings", "fulfilling-square",
  "circles-to-rhombuses", "semipolar", "self-building-square",
  "swapping-squares", "fulfilling-bouncing-circle", "fingerprint",
  "spring", "atom", "looping-rhombuses", "breeding-rhombus"),
  color = "#112446")
}
\arguments{
\item{spin}{Name of the spinner.}

\item{color}{Color of the spinner.}
}
\value{
an HTML tag.
}
\description{
Via \url{https://epic-spinners.epicmax.co/}.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinybusy)

  ui <- fluidPage(
    tags$h2("Epic spinner demo"),
    lapply(
      X = c(
        "flower", "pixel", "hollow-dots",
        "intersecting-circles", "orbit", "radar",
        "scaling-squares", "half-circle",
        "fulfilling-square", "circles-to-rhombuses"
      ),
      FUN = function(x) {
        tags$div(
          style = "display: table-cell; width: 150px; height: 100px; margin: 10px;",
          tags$b(x),
          spin_epic(x, color = "#08298A")
        )
      }
    ),
    tags$hr(),
    lapply(
      X = c(
        "semipolar", "self-building-square", "swapping-squares",
        "fulfilling-bouncing-circle", "fingerprint", "spring",
        "atom", "looping-rhombuses", "breeding-rhombus", "trinity-rings"
      ),
      FUN = function(x) {
        tags$div(
          style = "display: table-cell; width: 150px; height: 100px; margin: 10px;",
          tags$b(x),
          spin_epic(x, color = "#08298A")
        )
      }
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
