% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhanced-boxes.R
\name{widgetUserBox}
\alias{widgetUserBox}
\title{AdminLTE2 widget user box}
\usage{
widgetUserBox(..., title = NULL, subtitle = NULL, type = NULL,
  background = FALSE, backgroundUrl = NULL, src = NULL,
  color = NULL, footer = NULL, footer_padding = TRUE, width = 6,
  height = NULL, boxToolSize = "sm", collapsible = TRUE,
  closable = FALSE)
}
\arguments{
\item{...}{body content.}

\item{title}{box title.}

\item{subtitle}{box subtitle.}

\item{type}{NULL by default. Choose the value 2 to try another skin.}

\item{background}{Whether to enable a background image in the box header.}

\item{backgroundUrl}{image url, if any. Background needs to be TRUE.}

\item{src}{header image, if any (this is different of the background image).}

\item{color}{background color: see here for a list of valid colors \url{https://adminlte.io/themes/AdminLTE/pages/UI/general.html}.}

\item{footer}{box footer.}

\item{footer_padding}{TRUE by default: whether the footer has margin or not.}

\item{width}{box width (between 1 and 12).}

\item{height}{box height.}

\item{boxToolSize}{size of the toolbox: choose among "xs", "sm", "md", "lg".}

\item{collapsible}{If TRUE, display a button in the upper right that allows the user to collapse the box.}

\item{closable}{If TRUE, display a button in the upper right that allows the user to close the box.}
}
\description{
Create widget user box
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     widgetUserBox(
      title = "Nadia Carmichael",
      subtitle = "lead Developer",
      type = 2,
      src = "https://adminlte.io/themes/AdminLTE/dist/img/user7-128x128.jpg",
      color = "yellow",
      "Some text here!",
      footer = "The footer here!"
     ),
     widgetUserBox(
      title = "Alexander Pierce",
      subtitle = "Founder & CEO",
      type = NULL,
      src = "https://adminlte.io/themes/AdminLTE/dist/img/user1-128x128.jpg",
      color = "aqua-active",
      closable = TRUE,
      "Some text here!",
      footer = "The footer here!"
     ),
     widgetUserBox(
      title = "Elizabeth Pierce",
      subtitle = "Web Designer",
      type = NULL,
      src = "https://adminlte.io/themes/AdminLTE/dist/img/user3-128x128.jpg",
      background = TRUE,
      backgroundUrl = "https://www.planwallpaper.com/static/images/744081-background-wallpaper.jpg",
      closable = TRUE,
      "Some text here!",
      footer = "The footer here!"
     )
    ),
    title = "widgetUserBox"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
