% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardPagePlus.R
\name{dashboardPagePlus}
\alias{dashboardPagePlus}
\title{Dashboard Page with a right sidebar}
\usage{
dashboardPagePlus(
  header,
  sidebar,
  body,
  rightsidebar = NULL,
  footer = NULL,
  title = NULL,
  skin = c("blue", "blue-light", "black", "black-light", "purple", "purple-light",
    "green", "green-light", "red", "red-light", "yellow", "yellow-light", "midnight"),
  collapse_sidebar = FALSE,
  sidebar_background = NULL,
  sidebar_fullCollapse = FALSE,
  enable_preloader = FALSE,
  loading_duration = 2,
  md = FALSE
)
}
\arguments{
\item{header}{A header created by \code{dashboardHeaderPlus}.}

\item{sidebar}{A sidebar created by \code{\link[shinydashboard]{dashboardSidebar}}.}

\item{body}{A body created by \code{\link[shinydashboard]{dashboardBody}}.}

\item{rightsidebar}{A right sidebar created by \code{rightSidebar}. NULL by
default.}

\item{footer}{A footer created by \code{dashboardFooter}.}

\item{title}{A title to display in the browser's title bar. If no value is
provided, it will try to extract the title from the
\code{dashboardHeaderPlus}.}

\item{skin}{A color theme. See \url{https://adminlte.io/themes/AdminLTE/pages/UI/general.html}.}

\item{collapse_sidebar}{Whether to collapse the left sidebar. TRUE by default.}

\item{sidebar_background}{Main sidebar background color: either "light" or
NULL. NULL by default.}

\item{sidebar_fullCollapse}{Whether to fully collapse the sidebar as with shinydashboard.
FALSE by default.}

\item{enable_preloader}{Whether to enable a page loader. FALSE by default.}

\item{loading_duration}{Loader duration in seconds. 2s by default.}

\item{md}{Whether to enable material design. Experimental...}
}
\description{
This creates a dashboard page for use in a Shiny app.
}
\examples{
if (interactive()) {
library(shiny)
library(shinydashboard)
library(shinydashboardPlus)

shinyApp(
  ui = dashboardPagePlus(
    header = dashboardHeaderPlus(
     enable_rightsidebar = TRUE,
     rightSidebarIcon = "gears"
    ),
    sidebar = dashboardSidebar(),
    body = dashboardBody(),
    rightsidebar = rightSidebar(),
    title = "DashboardPage"
  ),
  server = function(input, output) { }
)
}
}
\seealso{
\code{\link{dashboardHeaderPlus}}, \code{\link[shinydashboard]{dashboardSidebar}},
  \code{\link[shinydashboard]{dashboardBody}}.
}
