% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{appButton}
\alias{appButton}
\title{AdminLTE2 special large button}
\usage{
appButton(..., inputId, label, icon = NULL, width = NULL)
}
\arguments{
\item{...}{Named attributes to be applied to the button or link.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{The contents of the button or link--usually a text label, but
you could also use any other HTML, like an image.}

\item{icon}{An optional \code{\link[shiny:icon]{icon()}} to appear on the button.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:reexports]{validateCssUnit()}}.}
}
\description{
Create a large button ideal for web applications but identical
to the classic Shiny action button.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "App Buttons",
      status = NULL,
      appButton(
        inputId = "myAppButton",
        label = "Users", 
        icon = icon("users"), 
        dashboardBadge(textOutput("btnVal"), color = "blue")
      )
     )
    ),
    title = "App buttons"
  ),
  server = function(input, output) {
   output$btnVal <- renderText(input$myAppButton)
  }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
