% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_visibility.R
\name{Effect_and_visibility}
\alias{Effect_and_visibility}
\alias{jqui_effect}
\alias{jqui_hide}
\alias{jqui_show}
\title{Apply jQuery UI effect.}
\usage{
jqui_effect(selector, effect, options = NULL, duration = 400,
  complete = NULL)

jqui_show(selector, effect, options = NULL, duration = 400,
  complete = NULL)

jqui_hide(selector, effect, options = NULL, duration = 400,
  complete = NULL)
}
\arguments{
\item{selector}{A \href{https://api.jquery.com/category/selectors/}{jQuery's
selector} that determines the shiny tag element(s) whose interaction is
enable or disable interactions.}

\item{effect}{A string indicating which
\href{http://jqueryui.com/effect/}{jQuery UI effect} to use for the
transition.}

\item{options}{A list of effect-specific
\href{http://api.jqueryui.com/category/effects/}{properties} and
\href{http://api.jqueryui.com/easings/}{easing}.}

\item{duration}{A string or number determining how long the animation will
run.}

\item{complete}{A function to call once the animation is complete, called
once per matched element.}
}
\description{
These functions are the R wrappers of
\href{http://api.jqueryui.com/effect/}{effect()},
\href{http://api.jqueryui.com/hide/}{hide()},
\href{http://api.jqueryui.com/show/}{show()} in jQuery UI library. They
should be used in \code{server} of a shiny document.
}
\details{
\describe{ \item{\code{jqui_effect}}{Apply an animation effect to matched
element(s).} \item{\code{jqui_hide}}{Hide the matched element(s) with
animation effect.} \item{\code{jqui_show}}{Display the matched element(s)
with animation effect.} }
}
\examples{
\dontrun{
  # in shiny ui create a plot
  plotOutput('foo')

  # in shiny server apply a 'bounce' effect to the plot
  jqui_effect('#foo', 'bounce')

  # in shiny server hide the plot with a 'fold' effect
  jqui_hide('#foo', 'fold')

  # in shiny server show the plot with a 'blind' effect
  jqui_show('#foo', 'blind')
}
}

