% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-recorder.R
\name{record_session}
\alias{record_session}
\title{Record a Session for Load Test}
\usage{
record_session(
  target_app_url,
  host = "127.0.0.1",
  port = 8600,
  output_file = "recording.log",
  open_browser = TRUE
)
}
\arguments{
\item{target_app_url}{The URL of the deployed application.}

\item{host}{The host where the proxy will run. Usually localhost is used.}

\item{port}{The port for the reverse proxy. Default is 8600. Change this
default if port 8600 is used by another service.}

\item{output_file}{The name of the generated recording file.}

\item{open_browser}{Whether to open a browser on the proxy (default=\code{TRUE})
or not (\code{FALSE}).}
}
\value{
Creates a recording file that can be used as input to the
\code{shinycannon} command-line load generation tool.
}
\description{
This function creates a \href{https://en.wikipedia.org/wiki/Reverse_proxy}{reverse proxy} at \verb{http://host:port}
(http://127.0.0.1:8600 by default) that intercepts and records activity
between your web browser and the Shiny application at \code{target_app_url}.
}
\details{
By default, after creating the reverse proxy, a web browser is opened
automatically. As you interact with the application in the web browser,
activity is written to the \code{output_file} (\code{recording.log} by default).

To shut down the reverse proxy and complete the recording, close the web
browser tab or window.

Recordings are used as input to the \code{shinycannon} command-line
load-generation tool which can be obtained from the \href{https://rstudio.github.io/shinyloadtest/index.html}{shinyloadtest documentation site}.
}
\section{\code{fileInput}/\code{DT}/\verb{HTTP POST} support}{


Shiny's \code{shiny::fileInput()} input for uploading files, the \code{DT} package,
and potentially other packages make HTTP POST requests to the target
application. Because POST requests can be large, they are not stored
directly in the recording file. Instead, new files adjacent to the
recording are created for each HTTP POST request intercepted.

The adjacent files are named after the recording with the pattern
\verb{<output_file>.post.<N>}, where \verb{<output_file>} is the chosen recording
file name and \verb{<N>} is the number of the request.

If present, these adjacent files must be kept alongside the recording file
when the recording is played back with the \code{shinycannon} tool.
}

\examples{
\dontrun{
  record_session("https://example.com/your-shiny-app/")
}
}
\seealso{
\href{https://rstudio.github.io/shinyloadtest/}{\code{shinyloadtest} articles}
}
