% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_and_load.R
\name{save_and_load}
\alias{save_and_load}
\title{Adds lines to modules to save and load input values.}
\usage{
save_and_load(folder_path, module = NULL)
}
\arguments{
\item{folder_path}{character. Path to the parent directory containing the application}

\item{module}{character. (optional) Name of a single module to edit}
}
\value{
No return value, called for side effects
}
\description{
Converts 'shiny' \verb{*Input} functions to lines of code required
to store and reload the values when the app is saved or loaded. By default
all the modules in the application are edited. Currently only input
functions from 'shiny' and \code{shinyWidgets::materialSwitch} are supported.
}
\examples{
td <- tempfile()
dir.create(td, recursive = TRUE)

modules <- data.frame(
  "component" = c("demo"),
  "long_component" = c("demo"),
  "module" = c("demo"),
  "long_module" = c("demo"),
  "map" = c(FALSE),
  "result" = c(TRUE),
  "rmd" = c(TRUE),
  "save" = c(TRUE),
  "async" = c(FALSE))

create_template(path = td, name = "demo",
                common_objects = c("demo"), modules = modules,
                author = "demo", include_map = FALSE,
                include_table = FALSE, include_code = FALSE, install = FALSE)

test_files <- list.files(
  system.file("extdata", package = "shinyscholar"),
  pattern = "test_test*", full.names = TRUE)

module_directory <- file.path(td, "demo", "inst", "shiny", "modules")
file.copy(test_files, module_directory, overwrite = TRUE)

save_and_load(file.path(td, "demo"), module = "test_test")

}
\author{
Simon E. H. Smart \href{mailto:simon.smart@cantab.net}{simon.smart@cantab.net}
}
