% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series.R
\name{get_LengthFraction}
\alias{get_LengthFraction}
\title{Calculate length fraction profile of copy number}
\usage{
get_LengthFraction(CN_data, genome_build = c("hg19", "hg38"),
  seg_cols = c("Chromosome", "Start.bp", "End.bp", "modal_cn"),
  samp_col = "sample")
}
\arguments{
\item{CN_data}{a \code{data.frame} with 'chromosome', 'start', 'end' and 'segVal'
(optinal) and 'sample' these five columns
(specify column names using \code{seg_cols} and \code{samp_cols} options)
or a \code{list} contains multiple data.frames,
each \code{data.frame} stores copy-number profile for one sample with
'chromosome', 'start', 'end' and 'segVal' (optional) these four columns.
If 'sample' column is not specified, will try using name of each \code{data.frame}.}

\item{genome_build}{genome build version, should be 'hg19' or 'hg38'.}

\item{seg_cols}{four characters used to specify chromosome, start position,
end position and copy number value in \code{input}, respectively.
Default use names from ABSOLUTE calling result.}

\item{samp_col}{a character used to specify the sample column name.}
}
\value{
a data table
}
\description{
Calculate length fraction profile of copy number
}
\examples{
# Load copy number list
load(system.file("extdata", "toy_cnlist.RData",
  package = "sigminer", mustWork = TRUE
))
annot <- get_LengthFraction(cn_list, seg_cols = c("chromosome", "start", "end", "segVal"))
}
\seealso{
Other internal calculation function series: \code{\link{get_ArmLocation}},
  \code{\link{get_cnlist}},
  \code{\link{get_cnsummary_sample}},
  \code{\link{get_components}}, \code{\link{get_features}},
  \code{\link{get_matrix}}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
\concept{internal calculation function series}
