% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality_indices.R
\name{pn_index}
\alias{pn_index}
\title{PN Centrality Index}
\usage{
pn_index(g, mode = c("all", "in", "out"))
}
\arguments{
\item{g}{igraph object with a sign edge attribute.}

\item{mode}{character string, “out” for out-pn, “in” for in-pn or “all” for undirected networks.}
}
\value{
centrality scores as numeric vector.
}
\description{
centrality index for signed networks by Everett and Borgatti
}
\examples{
A <- matrix(c(
    0, 1, 0, 1, 0, 0, 0, -1, -1, 0,
    1, 0, 1, -1, 1, -1, -1, 0, 0, 0,
    0, 1, 0, 1, -1, 0, 0, 0, -1, 0,
    1, -1, 1, 0, 1, -1, -1, 0, 0, 0,
    0, 1, -1, 1, 0, 1, 0, -1, 0, -1,
    0, -1, 0, -1, 1, 0, 1, 0, 1, -1,
    0, -1, 0, -1, 0, 1, 0, 1, -1, 1,
    -1, 0, 0, 0, -1, 0, 1, 0, 1, 0,
    -1, 0, -1, 0, 0, 1, -1, 1, 0, 1,
    0, 0, 0, 0, -1, -1, 1, 0, 1, 0
), 10, 10)
g <- graph_from_adjacency_matrix_signed(A,"undirected")
pn_index(g)
}
\references{
Everett, M. and Borgatti, S. (2014) Networks containing negative ties. \emph{Social Networks} 38 111-120
}
\author{
David Schoch
}
