% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARC-model.R
\name{ARC}
\alias{ARC}
\alias{ARC.default}
\alias{ARC.PATH}
\title{ARC model}
\usage{
ARC(x, ...)

\method{ARC}{default}(x, ...)

\method{ARC}{PATH}(x, ...)
}
\arguments{
\item{x}{input model}

\item{...}{arguments passed to methods}
}
\value{
ARC model
}
\description{
Arcs are unique paths that connect nodes. In a polygon layer with shared boundaries, the
arcs are the linear features that have no branches.
}
\details{
Nodes are the vertices where three or more arcs meet. An arc can exist without including
any nodes, a path that has no neighbouring relationship with another path.

This is \emph{not} the same terminology as used by other systems, such as "arc-node". The
\code{arc_link_vertex} mapping is inherently ordered, but we don't consider order of arcs.
Duplicated arcs (i.e. complementary turns around neighbouring polygons) are not kept.
The \code{object_link_arc} mapping records which arc belongs to the objects, so feature polygons
can in theory be reconstructed within objects by tracing \code{arc_link_vertex} start and end point
identity.
}
\examples{
a <- ARC(minimal_mesh)
sc_arc(a)
sc_arc(minimal_mesh)
}
