% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination.R
\name{generateChromosomeRecombinationPositions}
\alias{generateChromosomeRecombinationPositions}
\title{Generates a recombination vector arising from one meiotic event.
The origin of segments is coded as (0 - haplotype1 ,  1 - haplotype2 )}
\usage{
generateChromosomeRecombinationPositions(chromosomeLength = 500)
}
\arguments{
\item{chromosomeLength}{The length of the region in cm.}
}
\description{
Generates a recombination vector arising from one meiotic event.
The origin of segments is coded as (0 - haplotype1 ,  1 - haplotype2 )
}
\examples{

library("sim1000G")

# generate a recombination events for chromosome 4
readGeneticMap(4)
generateChromosomeRecombinationPositions(500)

}
