% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vlnorm}
\alias{vlnorm}
\title{Variate Generation for Log-Normal Distribution}
\usage{
vlnorm(
  n,
  meanlog = 0,
  sdlog = 1,
  stream = NULL,
  antithetic = FALSE,
  asList = FALSE
)
}
\arguments{
\item{n}{number of observations}

\item{meanlog}{Mean of distribution on log scale (default 0)}

\item{sdlog}{Standard deviation of distribution on log scale (default 1)}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via
\code{\link[=qlnorm]{stats::qlnorm}};
otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qlnorm]{stats::qlnorm}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

Otherwise, return a list with components suitable for visualizing inversion,
specifically:
\item{u}{        A vector of generated U(0,1) variates }
\item{x}{        A vector of log-normal random variates }
\item{quantile}{ Parameterized quantile function }
\item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Log-Normal Distribution
}
\details{
Generates random variates from the log-normal distribution.

Log-Normal variates are generated by inverting uniform(0,1) variates
produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
\code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}}
(if \code{stream} is not \code{NULL}).
In either case, \code{\link[=qlnorm]{stats::qlnorm}} is used to
invert the uniform(0,1) variate(s).
In this way, using \code{vlnorm} provides a monotone and synchronized
binomial variate generator, although not particularly fast.

The stream indicated must be an integer between 1 and 25 inclusive.

The log-normal distribution has density

\if{html}{\out{<div class="sourceCode">}}\preformatted{\deqn{f(x) = \frac{1}{\sqrt{2 \pi} \sigma x}
                 e^{-(\log{x} - \mu)^2 / (2 \sigma^2)} }{%
          f(x) = 1/(\sqrt(2 \pi) \sigma x) e^-((log x - \mu)^2 / (2 \sigma^2))}
}\if{html}{\out{</div>}}

where \eqn{\mu}{\mu} and \eqn{\sigma}{\sigma} are the mean and standard deviation
of the logarithm.

The mean is
\eqn{E(X) = \exp(\mu + 1/2 \sigma^2)}{E(X) = exp(\mu + 1/2 \sigma^2)},
the median is
\eqn{med(X) = \exp(\mu)}{med(X) = exp(\mu)},
and the variance is
\eqn{Var(X) = \exp(2\times \mu +\sigma^2)\times (\exp(\sigma^2)-1)}{%
   Var(X) = exp(2*\mu + \sigma^2)*(exp(\sigma^2) - 1)}
and hence the coefficient of variation is
\eqn{sqrt(\exp(\sigma^2)-1)}{sqrt(exp(\sigma^2) - 1)}
which is approximately \eqn{\sigma}{\sigma} when small
(e.g., \eqn{\sigma < 1/2}{\sigma < 1/2}).
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qlnorm
 vlnorm(3, meanlog = 5, sdlog = 0.5)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qlnorm
 vlnorm(3, 8, 2, stream = 1)
 vlnorm(3, 8, 2, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qlnorm
 vlnorm(1, 8, 2, stream = 1)
 vlnorm(1, 8, 2, stream = 2)
 vlnorm(1, 8, 2, stream = 1)
 vlnorm(1, 8, 2, stream = 2)
 vlnorm(1, 8, 2, stream = 1)
 vlnorm(1, 8, 2, stream = 2)

 set.seed(8675309)
 variates <- vlnorm(100, 8, 2, stream = 1)
 set.seed(8675309)
 variates <- vlnorm(100, 8, 2, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link{rstream}}, \code{\link{set.seed}},
\code{\link[=runif]{stats::runif}}

\code{\link[=rlnorm]{stats::rlnorm}}
}
\author{
Barry Lawson (\email{blawson@bates.edu}), \cr
Larry Leemis (\email{leemis@math.wm.edu}), \cr
Vadim Kudlay (\email{vkudlay@nvidia.com})
}
\concept{random variate generation}
\keyword{distribution}
