% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivalFunctions.R
\name{PWCsurvOS}
\alias{PWCsurvOS}
\title{OS Survival Function from Piecewise Constant Hazards}
\usage{
PWCsurvOS(t, h01, h02, h12, pw01, pw02, pw12)
}
\arguments{
\item{t}{(\code{numeric})\cr study time-points.}

\item{h01}{(\verb{numeric vector})\cr constant transition hazards for 0 to 1 transition.}

\item{h02}{(\verb{numeric vector})\cr constant transition hazards for 0 to 2 transition.}

\item{h12}{(\verb{numeric vector})\cr constant transition hazards for 1 to 2 transition.}

\item{pw01}{(\verb{numeric vector})\cr time intervals for the piecewise constant hazards \code{h01}.}

\item{pw02}{(\verb{numeric vector})\cr time intervals for the piecewise constant hazards \code{h02}.}

\item{pw12}{(\verb{numeric vector})\cr time intervals for the piecewise constant hazards \code{h12}.}
}
\value{
This returns the value of OS survival function at time t.
}
\description{
OS Survival Function from Piecewise Constant Hazards
}
\examples{
PWCsurvOS(1:5, c(0.3, 0.5), c(0.5, 0.8), c(0.7, 1), c(0, 4), c(0, 8), c(0, 3))
}
