% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctHeap.R
\name{correctSingleHeap}
\alias{correctSingleHeap}
\title{correctSingleHeap}
\usage{
correctSingleHeap(x, heap, before = 2, after = 2, method = "lnorm")
}
\arguments{
\item{x}{numeric vector representing age in years (integers)}

\item{heap}{numeric or integer vector of length 1 specifying the year
for which a heap should be corrected}

\item{before}{numeric or integer vector of length 1 specifying the number
of years before the heap that may be used to correct the heap. This input will
be rounded!}

\item{after}{numeric or integer vector of length 1 specifying the number
of years after the heap that may be used to correct the heap. This input will
be rounded!
\itemize{
\item \code{5year}: heaps are assumed to be every 5 years (0,5,10,...)
\item \code{10year}: heaps are assumed to be every 10 years (0,10,20,...)
}}

\item{method}{a character specifying the algorithm used to correct the age
heaps. Allowed values are
\itemize{
\item \code{lnorm}: drawing from a truncated log-normal distribution. The
required parameters are estimated using original input data.
\item \code{norm}: drawing from a truncated normal distribution. The
required parameters are estimated using original input data.
\item \code{unif}: random sampling from a (truncated) uniform distribution
}}
}
\value{
a numeric vector without age heaps
}
\description{
Correct a specific age heap in a vector containing age in years
}
\examples{
## create some artificial data
age <- rlnorm(10000, meanlog=2.466869, sdlog=1.652772)
age <- round(age[age < 93])
barplot(table(age))

## artificially introduce an age heap for a specific year
## and correct it
age23 <- c(age, rep(23, length=sum(age==23)))
cc23 <- rep("darkgrey", length(unique(age)))
cc23[24] <- "yellow"
barplot(table(age23), col=cc23)
barplot(table(correctSingleHeap(age23, heap=23, before=2, after=3, method="lnorm")), col=cc23)
barplot(table(correctSingleHeap(age23, heap=23, before=5, after=5, method="lnorm")), col=cc23)
}
