% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{OU2SSM}
\alias{OU2SSM}
\title{Convert Parameters from the Ornstein–Uhlenbeck Model
to State Space Model Parameterization}
\usage{
OU2SSM(mu, phi, sigma, delta_t)
}
\arguments{
\item{mu}{Numeric vector.
The long-term mean or equilibrium level
(\eqn{\boldsymbol{\mu}}).}

\item{phi}{Numeric matrix.
The rate of mean reversion,
determining how quickly the variable returns to its mean
(\eqn{\boldsymbol{\Phi}}).}

\item{sigma}{Numeric matrix.
The matrix of volatility
or randomness in the process
(\eqn{\boldsymbol{\Sigma}}).}

\item{delta_t}{Numeric.
Time interval (\eqn{\delta_t}).}
}
\value{
Returns a list of state space parameters:
\itemize{
\item \code{alpha}: Numeric vector.
Vector of intercepts for the dynamic model
(\eqn{\boldsymbol{\alpha}}).
\item \code{beta}: Numeric matrix.
Transition matrix relating the values of the latent variables
at time \code{t - 1} to those at time \code{t}
(\eqn{\boldsymbol{\beta}}).
\item \code{psi}: Numeric matrix.
The process noise covariance matrix
(\eqn{\boldsymbol{\Psi}}).
}
}
\description{
This function converts parameters from the Ornstein–Uhlenbeck model
to state space model parameterization.
}
\details{
The state space parameters
as a function of the  Ornstein–Uhlenbeck model parameters
are given by
\deqn{
      \boldsymbol{\beta}
      =
      \exp{
        \left(
          - \boldsymbol{\Phi}
          \Delta_{t}
        \right)
      }
  }

\deqn{
      \boldsymbol{\alpha}
      =
      - \boldsymbol{\Phi}^{-1}
      \left(
        \boldsymbol{\beta} - \mathbf{I}_{p}
      \right)
  }

\deqn{
      \mathrm{vec}
      \left(
        \boldsymbol{\Psi}
      \right)
      =
      \left\{
        \left[
          \left(
            - \boldsymbol{\Phi} \otimes \mathbf{I}_{p}
          \right)
          +
          \left(
            \mathbf{I}_{p} \otimes - \boldsymbol{\Phi}
          \right)
        \right]
        \left[
          \exp
          \left(
            \left[
              \left(
                - \boldsymbol{\Phi} \otimes \mathbf{I}_{p}
              \right)
              +
              \left(
                \mathbf{I}_{p} \otimes - \boldsymbol{\Phi}
              \right)
            \right]
            \Delta_{t}
        \right)
        -
        \mathbf{I}_{p \times p}
      \right]
      \mathrm{vec}
      \left(
        \boldsymbol{\Sigma}
      \right)
    \right\}
  }
}
\examples{
p <- k <- 2
mu <- c(5.76, 5.18)
phi <- matrix(
  data = c(0.10, -0.05, -0.05, 0.10),
  nrow = p
)
sigma <- matrix(
  data = c(2.79, 0.06, 0.06, 3.27),
  nrow = p
)
delta_t <- 0.10

OU2SSM(
  mu = mu,
  phi = phi,
  sigma = sigma,
  delta_t = delta_t
)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMOU}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SimSSMVAR}()},
\code{\link{SimSSM}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{ou}
\keyword{sim}
\keyword{simStateSpace}
