% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{as.data.frame.simstatespace}
\alias{as.data.frame.simstatespace}
\title{Coerce an Object of Class \code{simstatespace} to a Data Frame}
\usage{
\method{as.data.frame}{simstatespace}(
  x,
  row.names = NULL,
  optional = FALSE,
  eta = FALSE,
  long = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{simstatespace}.}

\item{row.names}{\code{NULL} or character vector giving the row names
for the data frame.
Missing values are not allowed.}

\item{optional}{Logical.
If \code{TRUE}, setting row names and converting column names is optional.}

\item{eta}{Logical.
If \code{eta = TRUE}, include \code{eta}.
If \code{eta = FALSE}, exclude \code{eta}.}

\item{long}{Logical.
If \code{long = TRUE}, use long format.
If \code{long = FALSE}, use wide format.}

\item{...}{Additional arguments.}
}
\description{
Coerce an Object of Class \code{simstatespace} to a Data Frame
}
\examples{
# prepare parameters
set.seed(42)
## number of individuals
n <- 5
## time points
time <- 50
## dynamic structure
p <- 3
mu0 <- rep(x = 0, times = p)
sigma0 <- diag(p)
sigma0_l <- t(chol(sigma0))
alpha <- rep(x = 0, times = p)
beta <- 0.50 * diag(p)
psi <- diag(p)
psi_l <- t(chol(psi))
## measurement model
k <- 3
nu <- rep(x = 0, times = k)
lambda <- diag(k)
theta <- 0.50 * diag(k)
theta_l <- t(chol(theta))
## covariates
j <- 2
x <- lapply(
  X = seq_len(n),
  FUN = function(i) {
    matrix(
      data = stats::rnorm(n = time * j),
      nrow = j,
      ncol = time
    )
  }
)
gamma <- diag(x = 0.10, nrow = p, ncol = j)
kappa <- diag(x = 0.10, nrow = k, ncol = j)

# Type 0
ssm <- SimSSMFixed(
  n = n,
  time = time,
  mu0 = mu0,
  sigma0_l = sigma0_l,
  alpha = alpha,
  beta = beta,
  psi_l = psi_l,
  nu = nu,
  lambda = lambda,
  theta_l = theta_l,
  type = 0
)

head(as.data.frame(ssm))
head(as.data.frame(ssm, long = FALSE))

# Type 1
ssm <- SimSSMFixed(
  n = n,
  time = time,
  mu0 = mu0,
  sigma0_l = sigma0_l,
  alpha = alpha,
  beta = beta,
  psi_l = psi_l,
  nu = nu,
  lambda = lambda,
  theta_l = theta_l,
  type = 1,
  x = x,
  gamma = gamma
)

head(as.data.frame(ssm))
head(as.data.frame(ssm, long = FALSE))

# Type 2
ssm <- SimSSMFixed(
  n = n,
  time = time,
  mu0 = mu0,
  sigma0_l = sigma0_l,
  alpha = alpha,
  beta = beta,
  psi_l = psi_l,
  nu = nu,
  lambda = lambda,
  theta_l = theta_l,
  type = 2,
  x = x,
  gamma = gamma,
  kappa = kappa
)

head(as.data.frame(ssm))
head(as.data.frame(ssm, long = FALSE))

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
