% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep.R
\name{sim_after_prep}
\alias{sim_after_prep}
\title{Start simulation after preparation.}
\usage{
sim_after_prep(
  df_sim_prep,
  r = 1000,
  poisson_test = FALSE,
  prob_lower = TRUE,
  progress = FALSE
)
}
\arguments{
\item{df_sim_prep}{dataframe as returned by
\code{\link[simaerep]{prep_for_sim}}}

\item{r}{integer, denotes number of simulations, default = 1000}

\item{poisson_test}{logical, calculates poisson.test pvalue}

\item{prob_lower}{logical, calculates probability for getting a lower value}

\item{progress}{logical, display progress bar, Default = TRUE}
}
\value{
dataframe
}
\description{
Internal function called by \code{\link[simaerep]{sim_sites}}
after \code{\link[simaerep]{prep_for_sim}}
}
\examples{
df_visit <- sim_test_data_study(
   n_pat = 100,
   n_sites = 5,
   frac_site_with_ur = 0.4,
   ur_rate = 0.2
)

df_visit$study_id <- "A"

df_site <- site_aggr(df_visit)

df_prep <- prep_for_sim(df_site, df_visit)

df_sim <- sim_after_prep(df_prep)

df_sim
}
\seealso{
\code{\link[simaerep]{sim_sites}},
\code{\link[simaerep]{prep_for_sim}}
}
