% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions.R
\name{rbern}
\alias{rbern}
\title{Bernoulli Node Distribution}
\usage{
rbern(n, prob)
}
\arguments{
\item{n}{Sample size.}

\item{prob}{A vector of success probabilities.}
}
\value{
Binary vector of length \code{n}.
}
\description{
Wrapper for Bernoulli node distribution.
}
\examples{
#---------------------------------------------------------------------------------------
# Specifying and simulating from a DAG with 3 Bernoulli nodes
#---------------------------------------------------------------------------------------
D <- DAG.empty()
D <- D + node("W1", distr="rbern", prob=0.05)
D <- D + node("W2", distr="rbern", prob=ifelse(W1==1,0.5,0.1))
D <- D + node("W3", distr="rbern", prob=ifelse(W1==1,0.5,0.1))
Dset <- set.DAG(D)
simdat <- simobs(Dset, n=200, rndseed=1)
}

