% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{sparseAdjMat.to.NetInd}
\alias{sparseAdjMat.to.NetInd}
\title{Convert Network from Sparse Adjacency Matrix into Network IDs Matrix}
\usage{
sparseAdjMat.to.NetInd(sparseAdjMat, trimKmax)
}
\arguments{
\item{sparseAdjMat}{Network represented as a sparse adjacency matrix (S4 class object \code{dgCMatrix} from package \code{Matrix}).
NOTE: The friends (row numbers) of observation \code{i} are assumed to be listed in column \code{i}
(i.e, \code{which(sparseAdjMat[,i])} are friends of \code{i}).}

\item{trimKmax}{Trim the maximum number of friends to this integer value. If this argument is not missing,
the conversion network matrix obtained from \code{sparseAdjMat} will be trimmed, so that each observation has at most \code{trimKmax} friends.
The trimming initiates from the last column of the network ID matrix, removing columns until only \code{trimKmax} columns are left.}
}
\value{
A named list with 3 items: 1) \code{NetInd_k}; 2) \code{nF}; and 3) \code{Kmax}.
1) \code{NetInd_k} - matrix of network IDs of dimension \code{(n=nrow(sparseAdjMat),Kmax)}, where each row \code{i} consists of the network IDs (friends) for observation \code{i}.
Remainders are filled with NAs.
2) \code{nF} - integer vector of length \code{n} specifying the number of friends for each observation.
3) \code{Kmax} - integer constant specifying the maximum observed number of friends in input \code{sparseAdjMat} (this is the column dimension for the output matrix \code{NetInd_k}).
}
\description{
Convert network represented by a sparse adjacency matrix into \code{simcausal} network IDs matrix (\code{NetInd_k}).
}
\seealso{
\code{\link{network}}; \code{\link{NetInd.to.sparseAdjMat}}; \code{\link{sparseAdjMat.to.igraph}}; \code{\link{igraph.to.sparseAdjMat}};
}
