% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_dina_class}
\alias{sim_dina_class}
\title{Simulate Binary Responses for a DINA Model}
\usage{
sim_dina_class(N, J, CLASS, ETA, gs, ss)
}
\arguments{
\item{N}{Number of Observations}

\item{J}{Number of Assessment Items}

\item{CLASS}{Does the individual possess all the necessary attributes?}

\item{ETA}{\eqn{\eta} Matrix containing indicators.}

\item{gs}{A \code{vec} describing the probability of guessing or
the probability subject correctly answers item \eqn{j} when at
least one attribute is lacking.}

\item{ss}{A \code{vec} describing the probability of slipping or
the probability of an incorrect response for individuals with
all of the required attributes}
}
\value{
A dichotomous item matrix with dimensions \eqn{N \times J}{N x J}.
}
\description{
Generate the dichotomous item matrix for a DINA Model.
}
\examples{
# Set 
N       = 100
rho     = 0
K       = 3

# Fixed Number of Assessment Items for Q
J = 18

# Specify Q
qbj = c(4, 2, 1, 4, 2, 1, 4, 2, 1, 6, 5, 3, 6, 5, 3, 7, 7, 7)

# Fill Q Matrix
Q = matrix(, J, K)
for (j in seq_len(J)) {
  Q[j,] = attribute_inv_bijection(K, qbj[j])
}

# Item parm vals
ss = gs = rep(.2, J)

# Generating attribute classes depending on correlation
if (rho == 0) {
  PIs = rep(1 / (2 ^ K), 2 ^ K)
  CLs = c(seq_len(2 ^ K) \%*\% rmultinom(n = N, size = 1, prob = PIs)) - 1
}

if (rho > 0) {
  Z = matrix(rnorm(N * K), N, K)
  Sig = matrix(rho, K, K)
  diag(Sig) = 1
  X = Z \%*\% chol(Sig)
  thvals = matrix(rep(0, K), N, K, byrow = T)
  Alphas = 1 * (X > thvals)
  CLs = Alphas \%*\% attribute_bijection(K)
}

# Simulate data under DINA model
ETA = sim_eta_matrix(K, J, Q)
Y_sim = sim_dina_class(N, J, CLs, ETA, gs, ss)
}
\seealso{
\code{\link[simcdm:sim_dina_attributes]{simcdm::sim_dina_attributes()}} and \code{\link[simcdm:sim_dina_items]{simcdm::sim_dina_items()}}
}
\author{
Steven Andrew Culpepper and James Joseph Balamuta
}
