% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_coverage.R
\name{calc_coverage}
\alias{calc_coverage}
\title{Calculate confidence interval coverage, width and MCSE}
\usage{
calc_coverage(
  res_dat,
  lower_bound,
  upper_bound,
  true_param,
  perfm_criteria = c("coverage", "width")
)
}
\arguments{
\item{res_dat}{data frame or tibble containing the simulation results.}

\item{lower_bound}{name of the column containing the lower bound estimates of the confidence intervals.}

\item{upper_bound}{name of the column containing the upper bound estimates of the confidence intervals.}

\item{true_param}{name of the column containing the true parameters.}

\item{perfm_criteria}{character or character vector indicating the performance criteria to be calculated.}
}
\value{
A tibble containing the number of simulation iterations, performance criteria estimate(s)
and the associated MCSE.
}
\description{
Calculates confidence interval coverage and width. The function also calculates the associated
Monte Carlo standard errors. The confidence interval percentage is based on how you calculated the lower
and upper bounds.
}
\examples{
calc_coverage(res_dat = t_res, lower_bound = lower_bound,
              upper_bound = upper_bound, true_param = true_param)


}
