% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_sources.R
\name{combine_sources}
\alias{combine_sources}
\title{Combine the dietary proportions from two food sources after running simmr}
\usage{
combine_sources(
  simmr_out,
  to_combine = simmr_out$input$source_names[1:2],
  new_source_name = "combined_source"
)
}
\arguments{
\item{simmr_out}{An object of class \code{simmr_output} created from
\code{\link{simmr_mcmc}} or \code{\link{simmr_ffvb}}}

\item{to_combine}{The names of exactly two sources. These should match the
names given to \code{\link{simmr_load}}.}

\item{new_source_name}{A name to give to the new combined source.}
}
\value{
A new \code{simmr_output} object
}
\description{
This function takes in an object of class \code{simmr_output} and combines
two of the food sources. It works for single and multiple group data.
}
\details{
Often two sources either (1) lie in similar location on the iso-space plot,
or (2) are very similar in phylogenetic terms. In case (1) it is common to
experience high (negative) posterior correlations between the sources.
Combining them can reduce this correlation and improve precision of the
estimates. In case (2) we might wish to determine the joint amount eaten of
the two sources when combined. This function thus combines two sources after
a run of \code{\link{simmr_mcmc}} or \code{\link{simmr_ffvb}} (known as
a posteriori combination). The new object can then be called with
\code{\link{plot.simmr_input}} or \code{\link{plot.simmr_output}} to
produce iso-space plots of summaries of the output after combination.
}
\examples{
\dontrun{
# The data
data(geese_data)

# Load into simmr

# Plot
plot(simmr_1)

# Print
simmr_1

# MCMC run
simmr_1_out <- simmr_mcmc(simmr_1)

# Print it
print(simmr_1_out)

# Summary
summary(simmr_1_out)
summary(simmr_1_out, type = "diagnostics")
summary(simmr_1_out, type = "correlations")
summary(simmr_1_out, type = "statistics")
ans <- summary(simmr_1_out, type = c("quantiles", "statistics"))

# Plot
plot(simmr_1_out)
plot(simmr_1_out, type = "boxplot")
plot(simmr_1_out, type = "histogram")
plot(simmr_1_out, type = "density")
plot(simmr_1_out, type = "matrix")

plot(simmr_out_combine$input)
plot(simmr_out_combine, type = "boxplot", title = "simmr output: combined sources")
}

}
\seealso{
See \code{\link{simmr_mcmc}} and \code{\link{simmr_ffvb}} and
the associated vignette for examples.
}
\author{
Andrew Parnell <andrew.parnell@mu.ie>, Emma Govan
}
