% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_vbar_fun.R
\name{ggplot_vbar_facet}
\alias{ggplot_vbar_facet}
\title{Vertical bar ggplot that is facetted.}
\usage{
ggplot_vbar_facet(data, x_var, y_var, facet_var, hover_var = NULL,
  x_scale_date_format = "\%Y", y_scale_zero = TRUE,
  y_scale_trans = "identity", y_scale_labels = waiver(),
  facet_scales = "fixed", facet_nrow = NULL, pal = NULL,
  width = 0.75, title = "[Title]", subtitle = NULL,
  x_title = "[X title]", y_title = "[Y title]", caption = NULL,
  font_family = "Helvetica", font_size_title = NULL,
  font_size_body = NULL, wrap_title = 70, wrap_subtitle = 80,
  wrap_x_title = 50, wrap_y_title = 50, wrap_caption = 80,
  isMobile = FALSE)
}
\arguments{
\item{data}{A tibble or dataframe. Required input.}

\item{x_var}{Unquoted numeric, date or categorical variable to be on the x axis. Required input.}

\item{y_var}{Unquoted numeric variable to be on the y axis. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{hover_var}{Unquoted variable to be an additional hover variable for when used inside plotly::ggplotly(). Defaults to NULL.}

\item{x_scale_date_format}{Date format for x axis labels.}

\item{y_scale_zero}{TRUE or FALSE of whether the minimum of the y scale is zero. Defaults to TRUE.}

\item{y_scale_trans}{A string specifying a transformation for the y axis scale, such as "log10" or "sqrt". Defaults to "identity".}

\item{y_scale_labels}{Argument to adjust the format of the y scale labels.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{facet_nrow}{The number of rows of facetted plots. Defaults to NULL, which generally chooses 2 rows. Not applicable to where isMobile is TRUE.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the Stats NZ palette.}

\item{width}{Width of bars. Defaults to 0.75.}

\item{title}{Title string. Defaults to [Title].}

\item{subtitle}{Subtitle string. Defaults to [Subtitle].}

\item{x_title}{X axis title string. Defaults to [X title].}

\item{y_title}{Y axis title string. Defaults to [Y title].}

\item{caption}{Caption title string. Defaults to NULL.}

\item{font_family}{Font family to use. Defaults NULL.}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{wrap_title}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{wrap_subtitle}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_x_title}{Number of characters to wrap the x title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_y_title}{Number of characters to wrap the y title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_caption}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. In a shinyapp, isMobile should be specified as input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Vertical bar ggplot that is facetted, but not coloured.
}
\examples{
plot_data <- dplyr::storms \%>\%
  dplyr::mutate(status = stringr::str_to_sentence(status)) \%>\%
  dplyr::group_by(year, status) \%>\%
  dplyr::summarise(average_wind = round(mean(wind), 2)) 

plot <- ggplot_vbar_facet(data = plot_data, x_var = year, y_var = average_wind,
                          facet_var = status)

plot

plotly::ggplotly(plot, tooltip = "text")
}
