% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet_basemap.R
\name{leaflet_basemap}
\alias{leaflet_basemap}
\title{Basemap stack in leaflet.}
\usage{
leaflet_basemap(top_layer = "light", bounds = NULL)
}
\arguments{
\item{top_layer}{The first layer to start in the basemap stack. Either "light", "dark", "street", "satellite", or "ocean". Defaults to "light".}

\item{bounds}{A bbox object or numeric vector of length four, with xmin, ymin, xmax and ymax values in WGS84 (epsg 4326).}
}
\value{
A leaflet object.
}
\description{
Make a stack of leaflet baselayers for use in shiny apps.
}
\examples{
leaflet_basemap("dark")

leaflet_basemap(bounds = c(166.70047,-34.45676, 178.52966,-47.06345))

bb <- rnaturalearth::ne_countries(scale = "small", 
           country = "Papua New Guinea", 
           returnclass = "sf") \%>\% 
     sf::st_bbox() 

leaflet_basemap("satellite", bounds = bb)  
}
