% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msim.R
\name{msim}
\alias{msim}
\title{Simulation of Multivariate Linear Model Data}
\usage{
msim(
  p = 15,
  q = c(5, 4, 3),
  m = 5,
  relpos = list(c(1, 2), c(3, 4, 6), c(5, 7)),
  gamma = 0.6,
  R2 = c(0.8, 0.7, 0.8),
  eta = 0,
  muX = NULL,
  muY = NULL,
  ypos = list(c(1), c(3, 4), c(2, 5))
)
}
\arguments{
\item{p}{Number of variables}

\item{q}{Vector containing the number of relevant predictor variables for each relevant response components}

\item{m}{Number of response variables}

\item{relpos}{A list of position of relevant component for predictor variables. The list contains vectors of position index, one vector or each relevant response components}

\item{gamma}{A declining (decaying) factor of eigen value of predictors (X). Higher the value of \code{gamma}, the decrease of eigenvalues will be steeper}

\item{R2}{Vector of coefficient of determination (proportion of variation explained by predictor variable) for each relevant response components}

\item{eta}{A declining (decaying) factor of eigenvalues of response (Y). Higher the value of \code{eta}, more will be the declining of eigenvalues of Y. \code{eta = 0} refers that all eigenvalues of responses (Y) are 1.}

\item{muX}{Vector of average (mean) for each predictor variable}

\item{muY}{Vector of average (mean) for each response variable}

\item{ypos}{List of position of relevant response components that are combined to generate response variable during orthogonal rotation}
}
\value{
A simrel object with all the input arguments along with following additional items
    \item{X}{Simulated predictors}
    \item{Y}{Simulated responses}
    \item{W}{Simulated predictor components}
    \item{Z}{Simulated response components}
    \item{beta}{True regression coefficients}
    \item{beta0}{True regression intercept}
    \item{relpred}{Position of relevant predictors}
    \item{testX}{Test Predictors}
    \item{testY}{Test Response}
    \item{testW}{Test predictor components}
    \item{testZ}{Test response components}
    \item{minerror}{Minimum model error}
    \item{Xrotation}{Rotation matrix of predictor (R)}
    \item{Yrotation}{Rotation matrix of response (Q)}
    \item{type}{Type of simrel object \emph{univariate} or \emph{multivariate}}
    \item{lambda}{Eigenvalues of predictors}
    \item{SigmaWZ}{Variance-Covariance matrix of components of response and predictors}
    \item{SigmaWX}{Covariance matrix of response components and predictors}
    \item{SigmaYZ}{Covariance matrix of response and predictor components}
    \item{Sigma}{Variance-Covariance matrix of response and predictors}
    \item{RsqW}{Coefficient of determination corresponding to response components}
    \item{RsqY}{Coefficient of determination corresponding to response variables}
}
\description{
Simulation of Multivariate Linear Model Data
}
\references{
Sæbø, S., Almøy, T., & Helland, I. S. (2015). simrel—A versatile tool for linear model data simulation based on the concept of a relevant subspace and relevant predictors. Chemometrics and Intelligent Laboratory Systems, 146, 128-135.

Almøy, T. (1996). A simulation study on comparison of prediction methods when only a few components are relevant. Computational statistics & data analysis, 21(1), 87-107.
}
\concept{linear model data}
\concept{simulation}
\keyword{datagen}
