% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simsl.main.R
\name{fit.simsl}
\alias{fit.simsl}
\title{Single-index models with a surface-link (workhorse function)}
\usage{
fit.simsl(y, A, X, mu.hat = NULL, family = "gaussian", bs = c("ps",
  "ps"), k = c(8, 8), knots = NULL, sp = NULL, method = "GCV.Cp",
  beta.ini = NULL, beta.ini.gam = FALSE, ind.to.be.positive = 1,
  pen.order = 0, lambda = 0, max.iter = 30, eps.iter = 0.01,
  trace.iter = TRUE, scale.X = TRUE, center.X = TRUE,
  si.main.effect = TRUE)
}
\arguments{
\item{y}{a n-by-1 vector of treatment outcomes; y is assumed to follow an exponential family distribution; any distribution supported by \code{mgcv::gam}.}

\item{A}{a n-by-1 vector of treatment variable; each element represents one of the L(>1) treatment conditions; e.g., c(1,2,1,1,1...); can be a factor-valued.}

\item{X}{a n-by-p matrix of pre-treatment covarates.}

\item{mu.hat}{a n-by-1 vector for efficinecy augmentation provided by the user; the defult is \code{NULL}; the optimal choice for this vector is h(E(y|X)), where h is the canonical link function.}

\item{family}{specifies the distribution of y; e.g., "gaussian", "binomial", "poisson"; the defult is "gaussian"; can be any family supported by \code{mgcv::gam}.}

\item{bs}{type of basis for representing the treatment-specific smooths; the defult is "ps" (p-splines); any basis supported by \code{mgcv::gam} can be used, e.g., "cr" (cubic regression splines)}

\item{k}{basis dimension; the same number (k) is used for all treatment groups, however, the smooths of different treatments have different roughness parameters.}

\item{knots}{a list containing user specified knot values to be used for basis construction (for the treatment and the index variables, respectively).}

\item{sp}{a vector of smoothing parameters associated with the 2-dimensional smooth}

\item{method}{the smoothing parameter estimation method; "GCV.Cp" to use GCV for unknown scale parameter and Mallows' Cp/UBRE/AIC for known scale; any method supported by \code{mgcv::gam} can be used.}

\item{beta.ini}{an initial solution of \code{beta.coef}; a p-by-1 vector; the defult is \code{NULL}.}

\item{beta.ini.gam}{if \code{TRUE}, employ a \code{mgcv::gam} smooth function representation of the variable A effect when inializing \code{beta.coef}; otherwise use a linear model representation for the A effect at initialization.}

\item{ind.to.be.positive}{for identifiability of the solution \code{beta.coef}, we restrict the jth component of \code{beta.coef} to be positive; by default \code{j=1}.}

\item{pen.order}{0 indicates the ridge penalty; 1 indicates the 1st difference penalty; 2 indicates the 2nd difference penalty, used in a penalized least squares (LS) estimation of \code{beta.coef}.}

\item{lambda}{a regularziation parameter associated with the penalized LS of \code{beta.coef}.}

\item{max.iter}{an integer specifying the maximum number of iterations for \code{beta.coef} update.}

\item{eps.iter}{a value specifying the convergence criterion of algorithm.}

\item{trace.iter}{if \code{TRUE}, trace the estimation process and print the differences in \code{beta.coef}.}

\item{scale.X}{if \code{TRUE}, scale X to have unit variance.}

\item{center.X}{if \code{TRUE}, center X to have zero mean.}

\item{si.main.effect}{if \code{TRUE}, once the convergece in the estimates of \code{beta.coef} is reached, include the main effect associated with the fitted single-index (beta.coef'X) to the final surface-link estimate.}
}
\value{
a list of information of the fitted SIMSL including
 \item{beta.coef}{ the estimated single-index coefficients.} \item{g.fit}{a \code{mgcv:gam} object containing information about the estimated 2-dimensional link function.} \item{beta.ini}{the initial value used in the estimation of \code{beta.coef}} \item{beta.path}{solution path of \code{beta.coef} over the iterations} \item{d.beta}{records the change in \code{beta.coef} over the solution path, \code{beta.path}} \item{X.scale}{sd of pretreatment covariates X} \item{X.center}{mean of pretreatment covariates X} \item{A.range}{range of the observed treatment variable A} \item{p}{number of baseline covariates X} \item{n}{number of subjects}
}
\description{
\code{fit.simsl} is the workhorse function for Single-index models with a surface-link (SIMSL).
}
\details{
The function estimates a linear combination (a single-index) of covariates X, and captures a nonlinear interactive structure between the single-index and the treatment defined on a continuum via a smooth surface-link on the index-treatment domain.

SIMSL captures the effect of covariates via a single-index and their interaction with the treatment via a 2-dimensional smooth link function.
Interaction effects are determined by shapes of the link function.
The model allows comparing different individual treatment levels and constructing individual treatment rules,
as functions of a biomarker signature (single-index), efficiently utilizing information on patient’s characteristics.
The resulting \code{simsl} object can be used to estimate an optimal dose rule for a new patient with pretreatment clinical information.
}
\seealso{
\code{pred.simsl},  \code{fit.simsl}
}
\author{
Park, Petkova, Tarpey, Ogden
}
