% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.model.R
\name{FGN}
\alias{FGN}
\title{Definition of a Fractional Gaussian Noise (FGN) Process}
\usage{
FGN(sigma2 = 1, H = 0.9999)
}
\arguments{
\item{sigma2}{A \code{double}.}

\item{H}{A \code{double}.}
}
\value{
An S3 object containing the specified ts.model with the following structure:
\describe{
 \item{process.desc}{Used in summary: "SIGMA2","H"}
 \item{theta}{Parameter vector including \eqn{\sigma^2}{sigma2}, \eqn{H}{H} }
 \item{plength}{Number of parameters}
 \item{print}{String containing simplified model}
 \item{desc}{"FGN"}
 \item{obj.desc}{Depth of Parameters e.g. list(1,1)}
 \item{starting}{Find starting values? TRUE or FALSE (e.g. specified value)}
}
}
\description{
Definition of a Fractional Gaussian Noise (FGN) Process
}
\examples{
FGN()
FGN(sigma2 = 1, H = 0.9999)
}
\author{
Lionel Voirol,  Davide Cucci
}
