% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_config.R
\name{create_config}
\alias{create_config}
\title{Create a list of configuration settings for some details of \code{\link[=sim_linelist]{sim_linelist()}}}
\usage{
create_config(...)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Named elements to replace
default settings. Only if names match exactly are elements replaced,
otherwise the function errors.}
}
\value{
A list of settings for \code{\link[=sim_linelist]{sim_linelist()}}
}
\description{
Create a list of configuration settings for some details of \code{\link[=sim_linelist]{sim_linelist()}}
}
\details{
The \code{config} argument in \code{\link[=sim_linelist]{sim_linelist()}} controls the small details
around time windows around infections (time of first contact and last
contact with infector), and the distribution of the Cycle threshold (Ct)
value from a Real-time PCR or quantitative PCR (qPCR) for confirmed
cases, the network effect in the simulation, and if there is a time-varying
death risk.

Accepted arguments and their defaults are:
\itemize{
\item \code{last_contact_distribution = "pois"}
\item \code{last_contact_distribution_params = c(lambda = 3)}
\item \code{first_contact_distribution = "pois"}
\item \code{first_contact_distribution_params = c(lambda = 3)}
\item \code{ct_distribution = "norm"}
\item \code{ct_distribution_params = c(mean = 25, sd = 2)}
\item \code{network = "adjusted"}
\item \code{time_varying_death_risk = NULL}
}

These parameters do not warrant their own arguments in
\code{\link[=sim_linelist]{sim_linelist()}} as they rarely need to be changed from their default
setting. Therefore it is not worth increasing the number of \code{\link[=sim_linelist]{sim_linelist()}}
arguments to accommodate these and the \code{config} argument keeps the function
signature simpler and more readable.

The accepted distributions are:
\itemize{
\item \code{last_contact_distribution = c("pois", "geom")}
\item \code{first_contact_distribution = c("pois", "geom")}
\item \code{ct_distribution = c("norm", "lnorm")}
}

The \code{network} option controls whether to sample contacts from a adjusted or
unadjusted contact distribution. Adjusted (default) sampling uses
\eqn{q(n) \sim (n + 1)p(n + 1)} where \eqn{p(n)} is the probability
density function of a distribution, e.g., Poisson or Negative binomial.
Unadjusted (\code{network = "unadjusted"}) instead samples contacts directly from
a probability distribution \eqn{p(n)}.
}
\examples{
# example with default configuration
create_config()

# example with customised Ct distribution
create_config(
  ct_distribution = "lnorm",
  ct_distribution_params = c(meanlog = 2, sdlog = 1)
)
}
