% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateFunctions.R
\name{curvilinear_c}
\alias{curvilinear_c}
\title{Curvilinear algorithm based on C code with r0 joint components}
\usage{
curvilinear_c(
  Ux,
  Uy,
  xData,
  yData,
  invLx,
  invLy,
  rho,
  tau = 0.01,
  alpha = 0.8,
  maxiter = 1000,
  tol = 1e-06,
  rj
)
}
\arguments{
\item{Ux}{Matrix with n.comp x n, initial value of Ux, comes from greedyMatch.}

\item{Uy}{Matrix with n.comp x n, initial value of Uy, comes from greedyMatch.}

\item{xData}{matrix with n x px, Xw = Lx \%*\% Xc.}

\item{yData}{matrix with n x py, Yw = Ly \%*\% Yc.}

\item{invLx}{Inverse matrix of Lx, matrix n x n.}

\item{invLy}{Inverse matrix of Ly, matrix n x n.}

\item{rho}{the weight parameter of matching relative to non-gaussianity.}

\item{tau}{initial step size, default value is 0.01}

\item{alpha}{controls weighting of skewness and kurtosis. Default value is 0.8, which corresponds to the Jarque-Bera test statistic with 0.8 weighting on squared skewness and 0.2 on squared kurtosis.}

\item{maxiter}{default value is 1000}

\item{tol}{the threshold of change in Ux and Uy to stop the curvilinear function}

\item{rj}{the joint rank, comes from greedyMatch.}
}
\value{
a list of matrices:
\describe{
      \item{\code{Ux}}{Optimized Ux with matrix n.comp x n.}
      \item{\code{Uy}}{Optimized Uy with matrix n.comp x n.}
      \item{\code{tau}}{step size}
      \item{\code{iter}}{number of iterations.}
      \item{\code{error}}{PMSE(Ux,Uxnew)+PMSE(Uy,Uynew)}
      \item{\code{obj}}{Objective Function value}
}
}
\description{
#' The curvilinear algorithm is modified from \href{https://www.semanticscholar.org/paper/A-feasible-method-for-optimization-with-constraints-Wen-Yin/d419879cdb80a87c3b7ab88e9f7478c1e70780ca}{Wen and Yin paper}.
}
