% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_raster_data.R
\name{.sits_raster_data_get_ts}
\alias{.sits_raster_data_get_ts}
\title{Extract a time series from raster}
\usage{
.sits_raster_data_get_ts(
  tile,
  points,
  bands,
  xy,
  cld_band = NULL,
  impute_fn = sits_impute_linear(),
  output_dir = output_dir
)
}
\arguments{
\item{tile}{Metadata describing a tile of a raster data cube.}

\item{points}{tibble with points}

\item{bands}{Bands to be retrieved.}

\item{xy}{A matrix with longitude as X and latitude as Y.}

\item{cld_band}{Cloud band (if available)}

\item{impute_fn}{Imputation function for NA values}

\item{output_dir}{An output directory to save temporary time series.}
}
\value{
A sits tibble with the time series.
}
\description{
Retrieve a set of time series for a raster data cube.
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
\keyword{internal}
