% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_imputation.R
\name{sits_impute_linear}
\alias{sits_impute_linear}
\title{Replace NA values with linear interpolation}
\usage{
sits_impute_linear(data = NULL)
}
\arguments{
\item{data}{A time series vector or matrix}
}
\value{
A set of filtered time series using
                      the imputation function.
}
\description{
Remove NA by linear interpolation
}
\examples{
if (sits_run_examples()) {
    # reading a lat/long from a local cube
    # create a cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    raster_cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir,
        delim = "_",
        parse_info = c("X1", "X2", "tile", "band", "date")
    )
    samples <- tibble::tibble(longitude = -55.66738, latitude = -11.76990)
    point_ndvi <- sits_get_data(
                  cube = raster_cube,
                  samples = samples,
                  impute_fn = sits_impute_linear())
    #
    # reading samples from a cube based on a  CSV file
    csv_file <- system.file("extdata/samples/samples_sinop_crop.csv",
        package = "sits"
    )
    points <- sits_get_data(cube = raster_cube, samples = csv_file)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
