% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_summary.R
\name{summary.sits_accuracy}
\alias{summary.sits_accuracy}
\title{Summarize accuracy matrix for training data}
\usage{
\method{summary}{sits_accuracy}(object, ...)
}
\arguments{
\item{object}{Object of class "sits_accuracy".}

\item{...}{Further specifications for \link{summary}.}
}
\value{
A summary of the sample accuracy
}
\description{
This is a generic function. Parameters depend on the specific
type of input.
}
\examples{
if (sits_run_examples()) {
    data(cerrado_2classes)
    # split training and test data
    train_data <- sits_sample(cerrado_2classes, frac = 0.5)
    test_data  <- sits_sample(cerrado_2classes, frac = 0.5)
    # train a random forest model
    rfor_model <- sits_train(train_data, sits_rfor())
    # classify test data
    points_class <- sits_classify(
        data = test_data,
        ml_model = rfor_model
    )
    # measure accuracy
    acc <- sits_accuracy(points_class)
    summary(acc)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
