% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_get_class.R
\name{sits_get_class}
\alias{sits_get_class}
\alias{sits_get_class.default}
\alias{sits_get_class.csv}
\alias{sits_get_class.shp}
\alias{sits_get_class.sf}
\alias{sits_get_class.sits}
\alias{sits_get_class.data.frame}
\title{Get values from classified maps}
\usage{
sits_get_class(cube, samples)

\method{sits_get_class}{default}(cube, samples)

\method{sits_get_class}{csv}(cube, samples)

\method{sits_get_class}{shp}(cube, samples)

\method{sits_get_class}{sf}(cube, samples)

\method{sits_get_class}{sits}(cube, samples)

\method{sits_get_class}{data.frame}(cube, samples)
}
\arguments{
\item{cube}{Classified data cube from where data is to be retrieved.
(class "class_cube").}

\item{samples}{Location of the samples to be retrieved.
Either a tibble of class "sits", an "sf" object,
the name of a shapefile or csv file, or
a data.frame with columns "longitude" and "latitude"}
}
\value{
A tibble of with columns
                       <longitude, latitude, start_date, end_date, label>.
}
\description{
Given a set of lat/long locations and a classified cube,
retrieve the class of each point.
}
\note{
There are four ways of specifying data to be retrieved using the
\code{samples} parameter:
(a) CSV file: a CSV file with columns \code{longitude}, \code{latitude};
(b) SHP file: a shapefile in POINT geometry;
(c) sits object: A sits tibble;
(d) sf object: An \code{link[sf]{sf}} object with POINT or geometry;
(e) data.frame: A data.frame with \code{longitude} and \code{latitude}.
}
\author{
Gilberto Camara
}
